/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.EnumDowelType;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.machine.EditmodeDestroyable;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.block.machine.TotemLatheMultiblock;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.TotemLatheBlockEntity;
import com.mraof.minestuck.blockentity.machine.TotemLatheDowelBlockEntity;
import com.mraof.minestuck.util.MSRotationUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TotemLatheBlock
extends MachineBlock
implements EditmodeDestroyable {
    protected final Map<Direction, VoxelShape> shape;
    protected final BlockPos mainPos;
    protected final TotemLatheMultiblock multiblock;

    public TotemLatheBlock(TotemLatheMultiblock multiblock, CustomVoxelShape shape, BlockPos mainPos, BlockBehaviour.Properties properties) {
        super(properties);
        this.multiblock = multiblock;
        this.shape = shape.createRotatedShapes();
        this.mainPos = mainPos;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shape.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos mainPos = this.getMainPos(state, pos);
        BlockEntity blockEntity = level.getBlockEntity(mainPos);
        if (blockEntity instanceof TotemLatheBlockEntity) {
            TotemLatheBlockEntity totemLathe = (TotemLatheBlockEntity)blockEntity;
            totemLathe.onRightClick(player, state);
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos mainPos = this.getMainPos(state, pos);
        BlockState otherState = level.getBlockState(mainPos);
        BlockEntity blockEntity = level.getBlockEntity(mainPos);
        if (blockEntity instanceof TotemLatheBlockEntity) {
            TotemLatheBlockEntity totemLathe = (TotemLatheBlockEntity)blockEntity;
            if (!otherState.isAir() && !state.isAir() && otherState.getValue((Property)FACING) == state.getValue((Property)FACING)) {
                totemLathe.checkStates();
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public void destroyFull(BlockState state, Level level, BlockPos pos) {
        Optional<MachineMultiblock.Placement> placement = this.multiblock.findPlacementFromSlot((LevelAccessor)level, this.getMainPos(state, pos));
        if (placement.isPresent()) {
            this.multiblock.removeAt((LevelAccessor)level, placement.get());
        } else {
            for (MachineMultiblock.Placement placementGuess : this.multiblock.guessPlacement(pos, state)) {
                this.multiblock.removeAt((LevelAccessor)level, placementGuess);
            }
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TotemLatheBlockEntity) {
            TotemLatheBlockEntity totemLathe = (TotemLatheBlockEntity)blockEntity;
            totemLathe.checkStates();
        }
    }

    public BlockPos getMainPos(BlockState state, BlockPos pos) {
        Rotation rotation = MSRotationUtil.fromDirection((Direction)state.getValue((Property)FACING));
        return pos.offset((Vec3i)this.mainPos.rotate(rotation));
    }

    public static class Slot
    extends TotemLatheBlock
    implements EntityBlock {
        public static final IntegerProperty COUNT = MSProperties.COUNT_0_2;

        public Slot(TotemLatheMultiblock machine, CustomVoxelShape shape, BlockBehaviour.Properties properties) {
            super(machine, shape, new BlockPos(0, 0, 0), properties);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new TotemLatheBlockEntity(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
            return BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.TOTEM_LATHE.get(), TotemLatheBlockEntity::tick);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{COUNT});
        }

        @Override
        public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
            BlockEntity blockEntity;
            if (!newState.is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof TotemLatheBlockEntity) {
                TotemLatheBlockEntity blockEntity2 = (TotemLatheBlockEntity)blockEntity;
                blockEntity2.dropItems();
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public static class DowelRod
    extends TotemLatheBlock
    implements EntityBlock {
        public static final EnumProperty<EnumDowelType> DOWEL = MSProperties.DOWEL_OR_NONE;
        protected final Map<Direction, VoxelShape> carvedShape;
        protected final Map<Direction, VoxelShape> dowelShape;

        public DowelRod(TotemLatheMultiblock machine, CustomVoxelShape emptyShape, CustomVoxelShape dowelShape, CustomVoxelShape carvedShape, BlockPos mainPos, BlockBehaviour.Properties properties) {
            super(machine, emptyShape, mainPos, properties);
            this.dowelShape = dowelShape.createRotatedShapes();
            this.carvedShape = carvedShape.createRotatedShapes();
        }

        @Override
        protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            if (((EnumDowelType)((Object)state.getValue(DOWEL))).equals((Object)EnumDowelType.CARVED_DOWEL)) {
                return this.carvedShape.get(state.getValue((Property)FACING));
            }
            if (((EnumDowelType)((Object)state.getValue(DOWEL))).equals((Object)EnumDowelType.DOWEL)) {
                return this.dowelShape.get(state.getValue((Property)FACING));
            }
            return super.getShape(state, worldIn, pos, context);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new TotemLatheDowelBlockEntity(pos, state);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{DOWEL});
        }

        @Override
        public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
            ItemStackBlockEntity blockEntity;
            ItemStack stack;
            BlockEntity blockEntity2;
            if (!newState.is((Block)this) && (blockEntity2 = level.getBlockEntity(pos)) instanceof ItemStackBlockEntity && !(stack = (blockEntity = (ItemStackBlockEntity)blockEntity2).getStack()).isEmpty()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                blockEntity.setStack(ItemStack.EMPTY);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

