/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.MSBlockShapes;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.block.machine.TotemLatheBlock;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TotemLatheMultiblock
extends MachineMultiblock {
    public final DeferredBlock<Block> CARD_SLOT = this.register("totem_lathe_card_slot", () -> new TotemLatheBlock.Slot(this, MSBlockShapes.TOTEM_LATHE_CARD_SLOT, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f).noLootTable()));
    public final DeferredBlock<Block> BOTTOM_LEFT = this.register("totem_lathe_bottom_left", () -> new TotemLatheBlock(this, MSBlockShapes.TOTEM_LATHE_BOTTOM_LEFT, new BlockPos(1, 0, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> BOTTOM_RIGHT = this.register("totem_lathe_bottom_right", () -> new TotemLatheBlock(this, MSBlockShapes.TOTEM_LATHE_BOTTOM_RIGHT, new BlockPos(2, 0, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> MIDDLE = this.register("totem_lathe_middle", () -> new TotemLatheBlock(this, MSBlockShapes.TOTEM_LATHE_MIDDLE, new BlockPos(0, -1, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> WHEEL = this.register("totem_lathe_wheel", () -> new TotemLatheBlock(this, MSBlockShapes.TOTEM_LATHE_MIDDLE_RIGHT, new BlockPos(2, -1, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> DOWEL_ROD = this.register("totem_lathe_dowel_rod", () -> new TotemLatheBlock.DowelRod(this, MSBlockShapes.TOTEM_LATHE_ROD, MSBlockShapes.TOTEM_LATHE_ROD_ACTIVE, MSBlockShapes.TOTEM_LATHE_ROD_ACTIVE, new BlockPos(1, -1, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> TOP = this.register("totem_lathe_top", () -> new TotemLatheBlock(this, MSBlockShapes.TOTEM_LATHE_TOP, new BlockPos(1, -2, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> TOP_CORNER = this.register("totem_lathe_top_corner", () -> new TotemLatheBlock(this, MSBlockShapes.TOTEM_LATHE_TOP_CORNER, new BlockPos(0, -2, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    private final MachineMultiblock.PlacementEntry slotPlacement = this.addDirectionPlacement(2, 0, 0, (Supplier<Block>)this.CARD_SLOT, Direction.NORTH);
    private final MachineMultiblock.PlacementEntry dowelPlacement;

    public TotemLatheMultiblock(DeferredRegister.Blocks register) {
        super(register);
        this.addDirectionPlacement(1, 0, 0, (Supplier<Block>)this.BOTTOM_LEFT, Direction.NORTH);
        this.addDirectionPlacement(0, 0, 0, (Supplier<Block>)this.BOTTOM_RIGHT, Direction.NORTH);
        this.addDirectionPlacement(2, 1, 0, (Supplier<Block>)this.MIDDLE, Direction.NORTH);
        this.dowelPlacement = this.addDirectionPlacement(1, 1, 0, (Supplier<Block>)this.DOWEL_ROD, Direction.NORTH);
        this.addDirectionPlacement(0, 1, 0, (Supplier<Block>)this.WHEEL, Direction.NORTH);
        this.addDirectionPlacement(1, 2, 0, (Supplier<Block>)this.TOP, Direction.NORTH);
        this.addDirectionPlacement(2, 2, 0, (Supplier<Block>)this.TOP_CORNER, Direction.NORTH);
    }

    public boolean isInvalidFromSlot(BlockGetter level, BlockPos pos) {
        return this.isInvalidFromPlacement(level, pos, this.slotPlacement);
    }

    public BlockPos getDowelPos(BlockPos tilePos, BlockState slotState) {
        return this.dowelPlacement.getPos(this.slotPlacement.findPlacementOrThrow(tilePos, slotState));
    }

    public Optional<MachineMultiblock.Placement> findPlacementFromSlot(LevelAccessor level, BlockPos pos) {
        return this.slotPlacement.findPlacement(pos, level.getBlockState(pos));
    }

    public BlockPos getSlotPos(BlockPos tilePos, BlockState state) {
        return this.slotPlacement.getPos(this.dowelPlacement.findPlacementOrThrow(tilePos, state));
    }
}

