/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.plant;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.plant.FlammableLeavesBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EndLeavesBlock
extends FlammableLeavesBlock {
    public static final int LEAF_SUSTAIN_DISTANCE = 5;

    public EndLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) > 5 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && (Integer)state.getValue((Property)DISTANCE) > 5) {
            EndLeavesBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        int i = this.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.getValue((Property)DISTANCE) != i) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return stateIn;
    }

    protected BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction facing : Direction.values()) {
            mutablePos.set((Vec3i)pos).move(facing);
            int axisDecrease = facing.getAxis() == Direction.Axis.X ? 2 : 1;
            i = Math.min(i, this.getDistance(level.getBlockState((BlockPos)mutablePos)) + axisDecrease);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    protected int getDistance(BlockState neighbor) {
        if (neighbor.is((Block)MSBlocks.END_LOG.get())) {
            return 0;
        }
        return neighbor.is((Block)this) ? (Integer)neighbor.getValue((Property)DISTANCE) : 7;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.updateDistance((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 2;
    }

    @Override
    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 50;
    }
}

