/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.plant;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.gen.feature.MSCFeatures;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EndSaplingBlock
extends BushBlock
implements BonemealableBlock {
    public static final BooleanProperty ALPHA = MSProperties.ALPHA;
    public static final BooleanProperty OMEGA = MSProperties.OMEGA;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final TreeGrower tree = new TreeGrower(Minestuck.id("end").toString(), Optional.empty(), Optional.of(MSCFeatures.END_TREE), Optional.empty());

    public EndSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ALPHA, (Comparable)Boolean.valueOf(false))).setValue((Property)OMEGA, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<EndSaplingBlock> codec() {
        return null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        if (level.isClientSide || level.dimensionType().moonPhase(level.getDayTime()) == 4) {
            return;
        }
        state = (double)rand.nextFloat() < 0.5 ? (BlockState)state.cycle((Property)ALPHA) : (BlockState)state.cycle((Property)OMEGA);
        if (((Boolean)state.getValue((Property)ALPHA)).booleanValue() && !((Boolean)state.getValue((Property)OMEGA)).booleanValue()) {
            this.tree.growTree(level, level.getChunkSource().getGenerator(), pos, state, rand);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ALPHA, OMEGA});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos groundPos = pos.below();
        return this.mayPlaceOn(level.getBlockState(groundPos), (BlockGetter)level, groundPos);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(MSTags.Blocks.END_SAPLING_DIRT);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            super.tick(state, level, pos, random);
            if (this.isValidBonemealTarget((LevelReader)level, pos, state) && random.nextInt(7) == 0) {
                this.performBonemeal(level, random, pos, state);
            }
        }
    }
}

