/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.plant;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.block.MSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowingMushroomBlock
extends BushBlock {
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public GlowingMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<GlowingMushroomBlock> codec() {
        return null;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender(level, pos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (this.canSpread((Level)level, pos, state) && random.nextInt(25) == 0) {
            int count = 0;
            Iterable blocks = BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4));
            for (BlockPos checkPos : blocks) {
                if (!level.getBlockState(checkPos).is((Block)this) || ++count < 5) continue;
                return;
            }
            for (int i = 0; i < 5; ++i) {
                BlockPos spreadPos = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
                if (!level.isEmptyBlock(spreadPos) || !this.canSpread((Level)level, spreadPos, this.defaultBlockState())) continue;
                level.setBlock(spreadPos, this.defaultBlockState(), 2);
                return;
            }
        }
    }

    public boolean canSpread(Level level, BlockPos pos, BlockState state) {
        BlockState soil = level.getBlockState(pos.below());
        return soil.is((Block)MSBlocks.BLUE_DIRT.get());
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.getOffset(pLevel, pPos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }
}

