/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.plant;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.FrogEntity;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TallEndGrassBlock
extends DoublePlantBlock {
    public TallEndGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is((Block)MSBlocks.END_GRASS.get());
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide && random.nextFloat() >= 0.75f) {
            List list = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)pos.getY(), (double)(pos.getZ() + 1)));
            for (LivingEntity livingentity : list) {
                if (livingentity.isShiftKeyDown() || livingentity.isSpectator() || livingentity instanceof FrogEntity) continue;
                this.randomTeleport((Level)level, livingentity);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        state = super.playerWillDestroy(level, pos, state, player);
        if (!level.isClientSide && !player.isCreative()) {
            this.randomTeleport(level, (LivingEntity)player);
        }
        return state;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, level, pos, rand);
        if (rand.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)pos.getX() + rand.nextFloat()), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void randomTeleport(Level level, LivingEntity livingEntity) {
        double oldPosX = livingEntity.getX();
        double oldPosY = livingEntity.getY();
        double oldPosZ = livingEntity.getZ();
        for (int i = 0; i < 16; ++i) {
            double newPosX = livingEntity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
            double newPosY = Mth.clamp((double)(livingEntity.getY() + (double)(livingEntity.getRandom().nextInt(16) - 8)), (double)0.0, (double)(level.getHeight() - 1));
            double newPosZ = livingEntity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
            if (livingEntity.isPassenger()) {
                livingEntity.stopRiding();
            }
            if (!livingEntity.randomTeleport(newPosX, newPosY, newPosZ, true)) continue;
            level.playSound(null, oldPosX, oldPosY, oldPosZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            livingEntity.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
            break;
        }
    }
}

