/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.redstone.AreaEffectBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AreaEffectBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ALL_MOBS = MSProperties.MACHINE_TOGGLE;
    public static final BooleanProperty SHUT_DOWN = MSProperties.SHUT_DOWN;
    public static final String EFFECT_CHANGE_MESSAGE = "effect_change_message";

    public AreaEffectBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ALL_MOBS, (Comparable)Boolean.valueOf(false))).setValue((Property)SHUT_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<AreaEffectBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AreaEffectBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.AREA_EFFECT.get(), AreaEffectBlockEntity::serverTick) : null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!AreaEffectBlock.canInteract(player) || !((blockEntity = level.getBlockEntity(pos)) instanceof AreaEffectBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AreaEffectBlockEntity be = (AreaEffectBlockEntity)blockEntity;
        ItemStack heldItemStack = player.getItemInHand(hand);
        if (heldItemStack.getItem() instanceof PotionItem) {
            this.clickWithPotion(level, pos, player, be, heldItemStack);
        } else if (level.isClientSide) {
            MSScreenFactories.displayAreaEffectScreen(be);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static boolean canInteract(Player player) {
        return player.isCreative() && !CreativeShockEffect.doesCreativeShockLimit(player, 1);
    }

    private void clickWithPotion(Level level, BlockPos pos, Player player, AreaEffectBlockEntity be, ItemStack potionStack) {
        MobEffectInstance firstEffect;
        if (potionStack.has(DataComponents.POTION_CONTENTS) && (firstEffect = (MobEffectInstance)((PotionContents)potionStack.get(DataComponents.POTION_CONTENTS)).getAllEffects().iterator().next()) != null && !level.isClientSide) {
            be.setEffect((Holder<MobEffect>)firstEffect.getEffect(), firstEffect.getAmplifier());
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".effect_change_message"), (Object[])new Object[]{Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{Component.translatable((String)firstEffect.getDescriptionId()), Component.translatable((String)("potion.potency." + firstEffect.getAmplifier()))})}), true);
            level.playSound(null, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            boolean hasPower;
            BlockState state = level.getBlockState(pos);
            boolean bl = hasPower = (Boolean)state.getValue((Property)SHUT_DOWN) == false && level.hasNeighborSignal(pos);
            if ((Boolean)state.getValue((Property)POWERED) != hasPower) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower)));
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{SHUT_DOWN});
        builder.add(new Property[]{ALL_MOBS});
    }
}

