/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BlockPressurePlateBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BlockPressurePlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entityIn) {
        if (entityIn instanceof Player) {
            this.tryDepressPlate(level, pos, state);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (!level.isClientSide) {
            boolean entityStandingOnBlock = BlockPressurePlateBlock.isPlayerStandingAbove((Level)level, pos);
            if (!entityStandingOnBlock && !BlockPressurePlateBlock.isAboveBlockFullyTouching((Level)level, pos.above()) && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.2f);
            } else if (entityStandingOnBlock) {
                level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 20);
            }
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.tryDepressPlate(level, pos, state);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.tryDepressPlate(level, pos, state);
    }

    public static boolean isAboveBlockFullyTouching(Level level, BlockPos abovePos) {
        return level.getBlockState(abovePos).isFaceSturdy((BlockGetter)level, abovePos, Direction.DOWN);
    }

    public static boolean isPlayerStandingAbove(Level level, BlockPos pos) {
        AABB checkBB = new AABB(pos);
        List list = level.getEntitiesOfClass(Player.class, checkBB.move(0.0, 0.5, 0.0));
        return list.stream().anyMatch(playerEntity -> playerEntity.onGround() && !playerEntity.isCrouching());
    }

    public void tryDepressPlate(Level level, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.above();
        if ((BlockPressurePlateBlock.isAboveBlockFullyTouching(level, abovePos) || BlockPressurePlateBlock.isPlayerStandingAbove(level, pos)) && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        }
        level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 20);
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }
}

