/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSHorizontalDirectionalBlock;
import com.mraof.minestuck.blockentity.redstone.BlockTeleporterBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class BlockTeleporterBlock
extends MSHorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BlockTeleporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!BlockTeleporterBlock.canInteract(player)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BlockTeleporterBlockEntity)) {
            return InteractionResult.PASS;
        }
        BlockTeleporterBlockEntity be = (BlockTeleporterBlockEntity)blockEntity;
        if (level.isClientSide) {
            MSScreenFactories.displayBlockTeleporterScreen(be);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static boolean canInteract(Player player) {
        return !CreativeShockEffect.doesCreativeShockLimit(player, 1);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        int newPower;
        BlockState newState;
        BlockState oldState = level.getBlockState(pos);
        if (oldState != (newState = BlockTeleporterBlock.setPower(oldState, newPower = level.getBestNeighborSignal(pos)))) {
            BlockEntity blockEntity;
            level.setBlockAndUpdate(pos, newState);
            if (((Boolean)newState.getValue((Property)POWERED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof BlockTeleporterBlockEntity) {
                BlockTeleporterBlockEntity teleporterBlockEntity = (BlockTeleporterBlockEntity)blockEntity;
                teleporterBlockEntity.handleTeleports();
            }
        }
    }

    public static BlockState setPower(BlockState state, int newPower) {
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(newPower > 0));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockTeleporterBlockEntity(pos, state);
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }
}

