/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.block.BlockUtil;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogicGateBlock
extends DiodeBlock {
    private final State logicOperator;

    public LogicGateBlock(BlockBehaviour.Properties properties, State gateState) {
        super(properties);
        this.logicOperator = gateState;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<LogicGateBlock> codec() {
        return null;
    }

    protected boolean shouldTurnOn(Level level, BlockPos pos, BlockState state) {
        Direction leftInput = ((Direction)state.getValue((Property)FACING)).getCounterClockWise();
        Direction rightInput = ((Direction)state.getValue((Property)FACING)).getClockWise();
        boolean leftInputSendingPower = this.getAlternateSignalAt((LevelReader)level, pos, leftInput) > 0;
        boolean rightInputSendingPower = this.getAlternateSignalAt((LevelReader)level, pos, rightInput) > 0;
        return this.logicOperator.operation.test(leftInputSendingPower, rightInputSendingPower);
    }

    protected int getAlternateSignalAt(LevelReader level, BlockPos pos, Direction side) {
        return level.getSignal(pos.relative(side), side);
    }

    public boolean isLocked(LevelReader level, BlockPos pos, BlockState state) {
        Direction behind = (Direction)state.getValue((Property)FACING);
        return this.getAlternateSignalAt(level, pos, behind) > 0;
    }

    protected int getDelay(BlockState state) {
        return 2;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (this.shouldTurnOn(level, pos, stateIn)) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{FACING});
    }

    public static enum State implements StringRepresentable
    {
        AND((left, right) -> left != false && right != false),
        OR((left, right) -> left != false || right != false),
        XOR((left, right) -> left != right),
        NAND(State.AND.operation.negate()),
        NOR(State.OR.operation.negate()),
        XNOR(State.XOR.operation.negate());

        private final BiPredicate<Boolean, Boolean> operation;

        private State(BiPredicate<Boolean, Boolean> operation) {
            this.operation = operation;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

