/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.MSDirectionalBlock;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.redstone.PlatformGeneratorBlock;
import com.mraof.minestuck.block.redstone.PlatformReceptacleBlock;
import com.mraof.minestuck.util.MSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlatformBlock
extends MSDirectionalBlock {
    public static final BooleanProperty INVISIBLE = MSProperties.INVISIBLE;
    public static final IntegerProperty GENERATOR_DISTANCE = MSProperties.DISTANCE_1_16;

    public PlatformBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATOR_DISTANCE, (Comparable)Integer.valueOf(1)));
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected RenderShape getRenderShape(BlockState state) {
        if (((Boolean)state.getValue((Property)INVISIBLE)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.MODEL;
    }

    public static void updateSurvival(BlockState state, Level level, BlockPos pos) {
        Direction stateFacing;
        BlockPos supportingPos;
        if (!level.isClientSide() && state.getBlock() instanceof PlatformBlock && level.isAreaLoaded(supportingPos = pos.relative((stateFacing = (Direction)state.getValue((Property)FACING)).getOpposite(), ((Integer)state.getValue((Property)GENERATOR_DISTANCE)).intValue()), 0)) {
            BlockState supportingState = level.getBlockState(supportingPos);
            PlatformBlock.checkForAbsorbers(state, level, pos, stateFacing);
            boolean supportingStateIsGenerator = supportingState.getBlock() instanceof PlatformGeneratorBlock;
            boolean generatorHasSameFacing = false;
            boolean generatorHasPower = false;
            if (supportingStateIsGenerator) {
                generatorHasSameFacing = supportingState.getValue((Property)PlatformGeneratorBlock.FACING) == stateFacing;
                generatorHasPower = (Boolean)supportingState.getValue((Property)PlatformGeneratorBlock.POWERED);
            }
            if (!(supportingStateIsGenerator && generatorHasPower && generatorHasSameFacing)) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            } else {
                boolean thisSetToInvisible;
                boolean generatorSetToInvisible = (Boolean)supportingState.getValue((Property)PlatformGeneratorBlock.INVISIBLE_MODE);
                if (generatorSetToInvisible != (thisSetToInvisible = ((Boolean)state.getValue((Property)INVISIBLE)).booleanValue())) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf(generatorSetToInvisible)));
                }
            }
        }
    }

    public static void checkForAbsorbers(BlockState state, Level level, BlockPos pos, Direction stateFacing) {
        for (int blockIterate = 1; blockIterate < (Integer)state.getValue((Property)GENERATOR_DISTANCE); ++blockIterate) {
            BlockPos iteratePos = pos.relative(stateFacing.getOpposite(), blockIterate);
            BlockState iterateState = level.getBlockState(iteratePos);
            if (!iterateState.is(MSTags.Blocks.PLATFORM_ABSORBING) && (!(iterateState.getBlock() instanceof PlatformReceptacleBlock) || !((Boolean)iterateState.getValue((Property)PlatformReceptacleBlock.ABSORBING)).booleanValue())) continue;
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        PlatformBlock.updateSurvival(state, level, pos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.tick(state, level, pos, rand);
        PlatformBlock.updateSurvival(state, (Level)level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 20);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{INVISIBLE});
        builder.add(new Property[]{GENERATOR_DISTANCE});
    }
}

