/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSDirectionalBlock;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.redstone.PlatformBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.redstone.PlatformGeneratorBlockEntity;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class PlatformGeneratorBlock
extends MSDirectionalBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty INVISIBLE_MODE = MSProperties.MACHINE_TOGGLE;
    public static final int MAX_GENERATOR_REACH = 16;

    public PlatformGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)INVISIBLE_MODE, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!CreativeShockEffect.doesCreativeShockLimit(player, 1)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)INVISIBLE_MODE), 3);
            level.playSound(null, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, (Boolean)state.getValue((Property)INVISIBLE_MODE) != false ? 1.5f : 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlatformGeneratorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.PLATFORM_GENERATOR.get(), PlatformGeneratorBlockEntity::serverTick) : null;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        int newPower;
        BlockState newState;
        BlockState oldState;
        if (!level.isClientSide && (oldState = level.getBlockState(pos)) != (newState = PlatformGeneratorBlock.setPower(oldState, newPower = level.getBestNeighborSignal(pos)))) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public static BlockState setPower(BlockState state, int newPower) {
        return (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(newPower > 0));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        Direction facing = (Direction)state.getValue((Property)FACING);
        for (int blockIterate = 1; blockIterate < 16; ++blockIterate) {
            BlockPos iteratePos = new BlockPos((Vec3i)pos.relative(facing, blockIterate));
            if (!level.isAreaLoaded(pos, blockIterate) || level.isOutsideBuildHeight(iteratePos.getY())) break;
            BlockState iterateBlockState = level.getBlockState(iteratePos);
            if (!(iterateBlockState.getBlock() instanceof PlatformBlock)) continue;
            PlatformBlock.updateSurvival(iterateBlockState, level, iteratePos);
        }
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(15) < (Integer)stateIn.getValue((Property)POWER)) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{INVISIBLE_MODE});
    }
}

