/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.redstone.PlatformBlock;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class PlatformReceptacleBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ABSORBING = MSProperties.MACHINE_TOGGLE;

    public PlatformReceptacleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ABSORBING, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!CreativeShockEffect.doesCreativeShockLimit(player, 1)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)ABSORBING), 3);
            level.playSound(null, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, (Boolean)state.getValue((Property)ABSORBING) != false ? 1.5f : 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    protected int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            BlockState state = level.getBlockState(pos);
            boolean energize = false;
            for (Direction direction : Direction.values()) {
                BlockState directionBlockState = level.getBlockState(pos.relative(direction));
                if (!(directionBlockState.getBlock() instanceof PlatformBlock) || directionBlockState.getValue((Property)PlatformBlock.FACING) != direction && directionBlockState.getValue((Property)PlatformBlock.FACING) != direction.getOpposite()) continue;
                energize = true;
            }
            if ((Boolean)state.getValue((Property)POWERED) != energize) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(energize)));
            }
        }
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{ABSORBING});
    }
}

