/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.effects.CreativeShockEffect;
import com.mraof.minestuck.util.MSDamageSources;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class RetractableSpikesBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty PRESSURE_SENSITIVE = MSProperties.MACHINE_TOGGLE;

    public RetractableSpikesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)PRESSURE_SENSITIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && fallDistance > 3.0f) {
            entityIn.causeFallDamage(fallDistance, 3.0f, level.damageSources().fall());
        } else {
            super.fallOn(level, state, pos, entityIn, fallDistance);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            this.tryExtendSpikes(level, pos, state, (Boolean)state.getValue((Property)PRESSURE_SENSITIVE));
            if (!level.isClientSide && (entityIn.xOld != entityIn.getX() || entityIn.zOld != entityIn.getZ()) && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                double distanceX = Math.abs(entityIn.getX() - entityIn.xOld);
                double distanceZ = Math.abs(entityIn.getZ() - entityIn.zOld);
                if (distanceX >= (double)0.003f || distanceZ >= (double)0.003f) {
                    entityIn.hurt(MSDamageSources.spike(level.registryAccess()), 1.0f);
                }
            }
        }
    }

    protected void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.tick(state, worldIn, pos, random);
        if (!worldIn.isClientSide) {
            boolean entityStandingOnBlock = false;
            AABB checkBB = new AABB(pos);
            List list = worldIn.getEntitiesOfClass(LivingEntity.class, checkBB.move(0.0, 0.5, 0.0));
            if (!list.isEmpty()) {
                for (LivingEntity livingEntity : list) {
                    entityStandingOnBlock = livingEntity.onGround() && !livingEntity.isCrouching();
                }
            }
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)PRESSURE_SENSITIVE)).booleanValue() || ((Boolean)state.getValue((Property)POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos) && !entityStandingOnBlock && ((Boolean)state.getValue((Property)PRESSURE_SENSITIVE)).booleanValue()) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
                worldIn.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
            } else {
                worldIn.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 20);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!CreativeShockEffect.doesCreativeShockLimit(player, 1)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)PRESSURE_SENSITIVE), 3);
            float pitch = (Boolean)state.getValue((Property)PRESSURE_SENSITIVE) != false ? 1.5f : 0.5f;
            level.playSound(null, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, pitch);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.tryExtendSpikes(level, pos, state, false);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.tryExtendSpikes(level, pos, state, false);
    }

    public void tryExtendSpikes(Level level, BlockPos pos, BlockState state, boolean steppedOn) {
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue() && (level.hasNeighborSignal(pos) || steppedOn)) {
            level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.2f);
            AABB stabBB = new AABB(pos);
            List list = level.getEntitiesOfClass(LivingEntity.class, stabBB.move(0.0, 0.5, 0.0));
            if (!list.isEmpty() && !level.isClientSide) {
                for (LivingEntity livingEntity : list) {
                    livingEntity.hurt(MSDamageSources.spike(level.registryAccess()), 4.0f);
                }
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (steppedOn || level.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 20);
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return PathType.DAMAGE_OTHER;
        }
        return PathType.WALKABLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{PRESSURE_SENSITIVE});
    }
}

