/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSDirectionalBlock;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.util.MSTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class RotatorBlock
extends MSDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ROTATION_FLIPPED = MSProperties.MACHINE_TOGGLE;

    public RotatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATION_FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        if (fromPos != pos.relative((Direction)state.getValue((Property)FACING))) {
            this.updatePower(level, pos);
        }
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        level.setBlock(pos, (BlockState)state.cycle((Property)ROTATION_FLIPPED), 3);
        if (((Boolean)state.getValue((Property)ROTATION_FLIPPED)).booleanValue()) {
            level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.2f);
        } else {
            level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
        }
        return InteractionResult.SUCCESS;
    }

    public void updatePower(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            BlockState state = level.getBlockState(pos);
            Direction stateFacing = (Direction)state.getValue((Property)FACING);
            boolean hasPower = BlockUtil.hasSignalNotFromFacing(level, pos, stateFacing);
            boolean isPoweredBeforeUpdate = (Boolean)state.getValue((Property)POWERED);
            if ((Boolean)state.getValue((Property)POWERED) != hasPower) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower)));
            }
            if (!isPoweredBeforeUpdate && hasPower) {
                BlockPos facingPos = pos.relative((Direction)state.getValue((Property)FACING));
                BlockState facingState = level.getBlockState(facingPos);
                BlockState rotatedFacingState = (Boolean)state.getValue((Property)ROTATION_FLIPPED) != false ? facingState.rotate((LevelAccessor)level, facingPos, Rotation.COUNTERCLOCKWISE_90) : facingState.rotate((LevelAccessor)level, facingPos, Rotation.CLOCKWISE_90);
                if (rotatedFacingState.canSurvive((LevelReader)level, pos) && !rotatedFacingState.hasLargeCollisionShape() && PistonBaseBlock.isPushable((BlockState)rotatedFacingState, (Level)level, (BlockPos)facingPos, null, (boolean)false, null) || rotatedFacingState.is(MSTags.Blocks.ROTATOR_WHITELISTED)) {
                    level.setBlockAndUpdate(facingPos, rotatedFacingState);
                }
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{ROTATION_FLIPPED});
    }
}

