/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.redstone.SummonerBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SummonerBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final BooleanProperty UNTRIGGERABLE = MSProperties.UNTRIGGERABLE;
    public static final String SUMMON_TYPE_CHANGE = "block.minestuck.summoner_block.summon_type_change";

    public SummonerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UNTRIGGERABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!SummonerBlock.canInteract(player) || !((blockEntity = level.getBlockEntity(pos)) instanceof SummonerBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        SummonerBlockEntity summoner = (SummonerBlockEntity)blockEntity;
        Item item = stack.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem eggItem = (SpawnEggItem)item;
            if (!level.isClientSide) {
                summoner.setSummonedEntity(eggItem.getType(stack));
                player.displayClientMessage((Component)Component.translatable((String)SUMMON_TYPE_CHANGE, (Object[])new Object[]{eggItem.getType(stack).getDescription()}), true);
            }
            level.playSound(player, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!SummonerBlock.canInteract(player) || !((blockEntity = level.getBlockEntity(pos)) instanceof SummonerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        SummonerBlockEntity summoner = (SummonerBlockEntity)blockEntity;
        if (level.isClientSide) {
            MSScreenFactories.displaySummonerScreen(summoner);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean canInteract(Player player) {
        return player.isCreative() && !CreativeShockEffect.doesCreativeShockLimit(player, 1);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.checkSummon(state, level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.checkSummon(state, level, pos);
    }

    private void checkSummon(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        boolean blockPowered;
        boolean bl = blockPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        if (!level.isClientSide && blockPowered && (!((Boolean)state.getValue((Property)TRIGGERED)).booleanValue() || ((Boolean)state.getValue((Property)UNTRIGGERABLE)).booleanValue()) && (blockEntity = level.getBlockEntity(pos)) instanceof SummonerBlockEntity) {
            SummonerBlockEntity summoner = (SummonerBlockEntity)blockEntity;
            summoner.summonEntity(level, pos, summoner.getSummonedEntity(), (Boolean)state.getValue((Property)UNTRIGGERABLE) == false, true);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SummonerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.SUMMONER.get(), SummonerBlockEntity::serverTick) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TRIGGERED});
        builder.add(new Property[]{UNTRIGGERABLE});
    }
}

