/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class TimedSolidSwitchBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    private final int tickRate;

    public TimedSolidSwitchBlock(BlockBehaviour.Properties properties, int tickRate) {
        super(properties);
        this.tickRate = tickRate;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf((Integer)state.getValue((Property)POWER) == 0 ? 15 : 0)), 3);
        if ((Integer)state.getValue((Property)POWER) > 0) {
            level.playSound(player, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.2f);
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.tickRate);
        } else {
            level.playSound(player, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.tick(state, level, pos, rand);
        int power = (Integer)state.getValue((Property)POWER);
        if (power >= 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(power - 1)));
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.tickRate);
            if (power - 1 == 0) {
                level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
            } else {
                level.playSound(null, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, 1.2f);
            }
        }
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.tickRate);
    }

    protected boolean isSignalSource(BlockState state) {
        return (Integer)state.getValue((Property)POWER) > 0;
    }

    protected int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(15) < (Integer)stateIn.getValue((Property)POWER)) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER});
    }
}

