/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSDirectionalBlock;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.redstone.StatStorerBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class TogglerBlock
extends MSDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty DISCHARGE = MSProperties.MACHINE_TOGGLE;

    public TogglerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)DISCHARGE, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        level.setBlock(pos, (BlockState)state.cycle((Property)DISCHARGE), 3);
        if (((Boolean)state.getValue((Property)DISCHARGE)).booleanValue()) {
            level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.2f);
        } else {
            level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        if (fromPos != pos.relative((Direction)state.getValue((Property)FACING))) {
            this.updatePower(level, pos);
        }
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            BlockState state = level.getBlockState(pos);
            Direction stateFacing = (Direction)state.getValue((Property)FACING);
            boolean hasPower = BlockUtil.hasSignalNotFromFacing(level, pos, stateFacing);
            boolean isPoweredBeforeUpdate = (Boolean)state.getValue((Property)POWERED);
            if ((Boolean)state.getValue((Property)POWERED) != hasPower) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower)));
            } else {
                level.sendBlockUpdated(pos, state, state, 2);
            }
            if (!isPoweredBeforeUpdate && hasPower) {
                BlockPos facingPos = pos.relative((Direction)state.getValue((Property)FACING));
                BlockState facingState = level.getBlockState(facingPos);
                if (((Boolean)state.getValue((Property)DISCHARGE)).booleanValue()) {
                    this.discharge(level, pos, state, facingPos, facingState);
                } else {
                    this.toggle(level, pos, state, facingPos, facingState);
                }
            }
        }
    }

    private void toggle(Level level, BlockPos pos, BlockState state, BlockPos facingPos, BlockState facingState) {
        if (facingState.hasProperty((Property)MSProperties.MACHINE_TOGGLE)) {
            level.setBlock(facingPos, (BlockState)facingState.cycle((Property)MSProperties.MACHINE_TOGGLE), 3);
            if (!level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).is(BlockTags.WOOL)) {
                level.playSound(null, facingPos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, (Boolean)facingState.getValue((Property)MSProperties.MACHINE_TOGGLE) != false ? 1.5f : 0.5f);
            }
        }
    }

    private void discharge(Level level, BlockPos pos, BlockState state, BlockPos facingPos, BlockState facingState) {
        BlockEntity blockEntity;
        boolean updated = false;
        if (facingState.isSignalSource()) {
            if (facingState.hasProperty((Property)BlockStateProperties.POWERED)) {
                level.setBlock(facingPos, (BlockState)facingState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 3);
                updated = true;
            }
            if (facingState.hasProperty((Property)BlockStateProperties.POWER)) {
                level.setBlock(facingPos, (BlockState)facingState.setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(0)), 3);
                updated = true;
            }
        }
        if ((blockEntity = level.getBlockEntity(facingPos)) instanceof StatStorerBlockEntity) {
            StatStorerBlockEntity statStorer = (StatStorerBlockEntity)blockEntity;
            statStorer.setActiveStoredStatValue(0.0f);
        }
        if (updated && !level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).is(BlockTags.WOOL)) {
            level.playSound(null, facingPos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, 0.5f);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{DISCHARGE});
    }
}

