/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.redstone.WirelessRedstoneTransmitterBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.redstone.WirelessRedstoneReceiverBlockEntity;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class WirelessRedstoneReceiverBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty AUTO_RESET = MSProperties.MACHINE_TOGGLE;
    public static final String NOW_AUTO = "minestuck.receiver_now_auto_reset";
    public static final String NOW_NOT_AUTO = "minestuck.receiver_now_not_auto_reset";

    public WirelessRedstoneReceiverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)AUTO_RESET, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<WirelessRedstoneReceiverBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WirelessRedstoneReceiverBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.WIRELESS_REDSTONE_RECEIVER.get(), WirelessRedstoneReceiverBlockEntity::serverTick) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!CreativeShockEffect.doesCreativeShockLimit(player, 1)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)AUTO_RESET), 3);
            if (((Boolean)state.getValue((Property)AUTO_RESET)).booleanValue()) {
                if (!level.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)NOW_NOT_AUTO));
                }
                level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.2f);
            } else {
                if (!level.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)NOW_AUTO));
                }
                level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void updatePower(Level level, BlockPos posIn, BlockPos transmitterPos) {
        BlockEntity blockEntity;
        int newPower;
        BlockState newState;
        BlockState receiverState = level.getBlockState(posIn);
        if (receiverState != (newState = WirelessRedstoneReceiverBlock.setPower(receiverState, newPower = ((Integer)level.getBlockState(transmitterPos).getValue((Property)WirelessRedstoneTransmitterBlock.POWER)).intValue()))) {
            level.setBlockAndUpdate(posIn, newState);
        }
        if ((blockEntity = level.getBlockEntity(posIn)) instanceof WirelessRedstoneReceiverBlockEntity) {
            WirelessRedstoneReceiverBlockEntity be = (WirelessRedstoneReceiverBlockEntity)blockEntity;
            be.setLastTransmitterBlockPos(transmitterPos);
        }
    }

    public static BlockState setPower(BlockState state, int newPower) {
        return (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(newPower > 0));
    }

    public int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(15) < (Integer)stateIn.getValue((Property)POWER)) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{AUTO_RESET});
        builder.add(new Property[]{FACING});
    }
}

