/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.redstone;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.redstone.WirelessRedstoneTransmitterBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.effects.CreativeShockEffect;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class WirelessRedstoneTransmitterBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public WirelessRedstoneTransmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<WirelessRedstoneTransmitterBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WirelessRedstoneTransmitterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.WIRELESS_REDSTONE_TRANSMITTER.get(), WirelessRedstoneTransmitterBlockEntity::serverTick) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!WirelessRedstoneTransmitterBlock.canInteract(player) || !((blockEntity = level.getBlockEntity(pos)) instanceof WirelessRedstoneTransmitterBlockEntity)) {
            return InteractionResult.PASS;
        }
        WirelessRedstoneTransmitterBlockEntity transmitter = (WirelessRedstoneTransmitterBlockEntity)blockEntity;
        if (level.isClientSide) {
            MSScreenFactories.displayWirelessRedstoneTransmitterScreen(transmitter);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean canInteract(Player player) {
        return !CreativeShockEffect.doesCreativeShockLimit(player, 1);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        int newPower;
        BlockState newState;
        BlockState oldState;
        if (!level.isClientSide && (oldState = level.getBlockState(pos)) != (newState = WirelessRedstoneTransmitterBlock.setPower(oldState, newPower = level.getBestNeighborSignal(pos)))) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public static BlockState setPower(BlockState state, int newPower) {
        return (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(newPower > 0));
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(15) < (Integer)stateIn.getValue((Property)POWER)) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWER});
        builder.add(new Property[]{POWERED});
    }
}

