/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.block.machine.ComputerBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.computer.ComputerReference;
import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.computer.ProgramTypes;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.computer.SburbServerData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.computer.theme.MSComputerThemes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ComputerBlockEntity
extends BlockEntity
implements ISburbComputer {
    public static final String DISK_REJECT = "block.minestuck.computer.disk_reject";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DISK_CAPACITY = 4;
    private static final Codec<NonNullList<ItemStack>> DISK_LIST_CODEC = NonNullList.codecOf((Codec)ItemStack.SINGLE_ITEM_CODEC);
    @Nullable
    private Runnable guiCallback = null;
    @Nullable
    private PlayerIdentifier owner;
    private int ownerId;
    private final NonNullList<ItemStack> disks = NonNullList.createWithCapacity((int)4);
    private final Map<ProgramType<?>, ProgramType.Data> existingPrograms = new HashMap();
    private ResourceLocation computerTheme = MSComputerThemes.DEFAULT;

    public ComputerBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.COMPUTER.get(), pos, state);
        this.insertNewProgramInstance(ProgramTypes.DISK_BURNER.get());
        this.insertNewProgramInstance(ProgramTypes.SETTINGS.get());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.disks.clear();
        if (tag.contains("disks")) {
            DISK_LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("disks")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(arg_0 -> this.disks.addAll(arg_0));
        }
        CompoundTag programs = tag.getCompound("programs");
        for (String programKey : programs.getAllKeys()) {
            ProgramType programType = ResourceLocation.read((String)programKey).result().flatMap(arg_0 -> ProgramTypes.REGISTRY.getOptional(arg_0)).orElse(null);
            if (programType == null) {
                LOGGER.error("Unknown program type by name \"{}\" in computer data.", (Object)programKey);
                continue;
            }
            this.insertNewProgramInstance(programType).read(programs.getCompound(programKey));
        }
        if (tag.contains("theme", 8)) {
            this.computerTheme = Objects.requireNonNullElse(ResourceLocation.tryParse((String)tag.getString("theme")), this.computerTheme);
        } else if (tag.contains("theme", 3)) {
            this.computerTheme = MSComputerThemes.getThemeFromOldOrdinal(tag.getInt("theme"));
        }
        if (tag.contains("ownerId")) {
            this.ownerId = tag.getInt("ownerId");
        } else {
            this.owner = IdentifierHandler.load(tag, "owner").result().orElse(null);
        }
        if (this.guiCallback != null) {
            this.guiCallback.run();
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            this.owner.saveToNBT(tag, "owner");
        }
        this.writeSharedData(tag, ProgramType.Data::write);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compoundtag = new CompoundTag();
        super.saveAdditional(compoundtag, provider);
        if (this.owner != null) {
            compoundtag.putInt("ownerId", this.owner.getId());
        }
        this.writeSharedData(compoundtag, programData -> programData.writeForSync(this, this.getLevel().getServer()));
        return compoundtag;
    }

    private void writeSharedData(CompoundTag tag, Function<ProgramType.Data, CompoundTag> serializer) {
        tag.put("disks", (Tag)DISK_LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.disks).result().orElseThrow());
        CompoundTag programs = new CompoundTag();
        for (Map.Entry<ProgramType<?>, ProgramType.Data> entry : this.existingPrograms.entrySet()) {
            String programKey = Objects.requireNonNull(ProgramTypes.REGISTRY.getKey(entry.getKey())).toString();
            programs.put(programKey, (Tag)serializer.apply(entry.getValue()));
        }
        tag.put("programs", (Tag)programs);
        tag.putString("theme", this.computerTheme.toString());
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        for (ProgramType<?> programType : this.existingPrograms.keySet()) {
            programType.eventHandler().onLoad(this);
        }
    }

    public boolean isBrokenOrOff() {
        ComputerBlock.State state = (ComputerBlock.State)((Object)this.getBlockState().getValue(ComputerBlock.STATE));
        return state == ComputerBlock.State.BROKEN || state == ComputerBlock.State.OFF;
    }

    public boolean hasExistingProgram(ProgramType<?> programType) {
        return this.existingPrograms.containsKey(programType);
    }

    private <D extends ProgramType.Data> D insertNewProgramInstance(ProgramType<D> programType) {
        D data = programType.newDataInstance(this::markDirtyAndResend);
        this.existingPrograms.put(programType, (ProgramType.Data)data);
        return data;
    }

    public <D extends ProgramType.Data> Optional<D> getProgramData(Supplier<ProgramType<D>> type) {
        return this.getProgramData(type.get());
    }

    public <D extends ProgramType.Data> Optional<D> getProgramData(ProgramType<D> type) {
        return Optional.ofNullable(this.existingPrograms.get(type));
    }

    @Override
    public Optional<SburbClientData> getSburbClientData() {
        return this.getProgramData((Supplier)ProgramTypes.SBURB_CLIENT);
    }

    @Override
    public Optional<SburbServerData> getSburbServerData() {
        return this.getProgramData((Supplier)ProgramTypes.SBURB_SERVER);
    }

    public void tryEjectDisk(int diskIndex) {
        if (this.level == null) {
            return;
        }
        if (0 <= diskIndex && diskIndex < this.disks.size()) {
            ItemStack disk = (ItemStack)this.disks.get(diskIndex);
            this.removeDisk(diskIndex);
            BlockPos pos = this.getBlockPos();
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)disk);
        }
    }

    public boolean tryConsumeBlankDisk() {
        for (int index = 0; index < this.disks.size(); ++index) {
            if (!((ItemStack)this.disks.get(index)).is(MSItems.BLANK_DISK)) continue;
            this.removeDisk(index);
            return true;
        }
        return false;
    }

    public void dropAllDisks() {
        if (this.level == null) {
            return;
        }
        for (ItemStack disk : this.disks) {
            BlockPos pos = this.getBlockPos();
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)disk);
        }
        this.disks.clear();
    }

    private void removeDisk(int index) {
        boolean hasSBURBProgram;
        Holder typeHolder;
        ItemStack diskToDelete = (ItemStack)this.disks.get(index);
        if (diskToDelete.has(MSItemComponents.PROGRAM_TYPE) && (typeHolder = (Holder)diskToDelete.getComponents().get(MSItemComponents.PROGRAM_TYPE.get())) != null) {
            ((ProgramType)typeHolder.value()).eventHandler().onClosed(this);
            this.existingPrograms.remove(typeHolder.value());
        }
        boolean bl = hasSBURBProgram = this.hasExistingProgram((ProgramType)ProgramTypes.SBURB_CLIENT.get()) || this.hasExistingProgram((ProgramType)ProgramTypes.SBURB_SERVER.get());
        if (!hasSBURBProgram) {
            this.setComputerBlockState(ComputerBlock.State.ON);
        }
        this.level.playSound(null, this.getBlockPos(), MSSoundEvents.COMPUTER_DISK_REMOVE.get(), SoundSource.BLOCKS);
        this.disks.remove(index);
        this.markDirtyAndResend();
    }

    public void closeAll() {
        for (ProgramType<?> programType : this.existingPrograms.keySet()) {
            programType.eventHandler().onClosed(this);
        }
    }

    public Stream<ProgramType<?>> installedPrograms() {
        return this.existingPrograms.keySet().stream();
    }

    public boolean hasBlankDisks() {
        return this.disks.stream().anyMatch(stack -> stack.is((Item)MSItems.BLANK_DISK.get()));
    }

    public NonNullList<ItemStack> getDisks() {
        return this.disks;
    }

    public boolean hasRoomForDisk() {
        return this.disks.size() < 4;
    }

    @Override
    @Nullable
    public PlayerIdentifier getOwner() {
        return this.owner;
    }

    public void initializeOwner(PlayerIdentifier owner) {
        if (this.owner != null) {
            throw new IllegalStateException("Not allowed to set computer owner in this state");
        }
        this.owner = owner;
    }

    public int clientSideOwnerId() {
        return this.ownerId;
    }

    @Override
    public ComputerReference createReference() {
        return ComputerReference.of(this);
    }

    public ResourceLocation getTheme() {
        return this.computerTheme;
    }

    public void setTheme(ResourceLocation themeId) {
        this.computerTheme = themeId;
        this.markDirtyAndResend();
    }

    public boolean tryInsertDisk(Player player, ItemStack stackInHand) {
        boolean holdingProgramDisk;
        if (this.isBrokenOrOff() || this.level == null || stackInHand.isEmpty()) {
            return false;
        }
        Holder optionalType = (Holder)stackInHand.get(MSItemComponents.PROGRAM_TYPE);
        boolean holdingBlankDisk = stackInHand.is(MSItems.BLANK_DISK);
        boolean holdingDisc11Disk = stackInHand.is(Items.MUSIC_DISC_11);
        boolean bl = holdingProgramDisk = optionalType != null;
        if (!this.hasRoomForDisk()) {
            if (!this.level.isClientSide && (holdingBlankDisk || holdingDisc11Disk || holdingProgramDisk)) {
                player.sendSystemMessage((Component)Component.translatable((String)DISK_REJECT));
            }
            return false;
        }
        if (holdingBlankDisk) {
            this.takeDisk(stackInHand);
            return true;
        }
        if (holdingDisc11Disk && !this.level.isClientSide) {
            this.closeAll();
            this.setComputerBlockState(ComputerBlock.State.BROKEN);
            this.takeDisk(stackInHand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MSCriteriaTriggers.BRICK_COMPUTER.get().trigger(serverPlayer);
            }
            return true;
        }
        if (holdingProgramDisk) {
            ProgramType programType = (ProgramType)optionalType.value();
            if (!this.level.isClientSide && !this.hasExistingProgram(programType)) {
                this.insertNewProgramInstance(programType);
                this.setComputerBlockState(ComputerBlock.State.GAME_LOADED);
                this.takeDisk(stackInHand);
                programType.eventHandler().onDiskInserted(this);
            }
            return true;
        }
        return false;
    }

    private void takeDisk(ItemStack stackInHand) {
        this.disks.add((Object)stackInHand.split(1));
        this.markDirtyAndResend();
        this.level.playSound(null, this.getBlockPos(), MSSoundEvents.COMPUTER_DISK_INSERT.get(), SoundSource.BLOCKS);
    }

    public void setGuiCallback(Runnable guiCallback) {
        if (this.level == null || !this.level.isClientSide()) {
            throw new IllegalStateException("Tried to set gui callback in a non-client context");
        }
        this.guiCallback = guiCallback;
    }

    public void setComputerBlockState(ComputerBlock.State state) {
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(ComputerBlock.STATE, (Comparable)((Object)state)), 2);
        this.markDirtyAndResend();
    }

    private void markDirtyAndResend() {
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    public static Optional<ComputerBlockEntity> getAccessibleComputer(ServerPlayer player, BlockPos pos) {
        return MSPacket.getAccessibleBlockEntity(player, pos, ComputerBlockEntity.class).filter(computer -> computer.canAccessComputer(player));
    }

    public boolean canAccessComputer(ServerPlayer player) {
        if (this.isBrokenOrOff()) {
            return false;
        }
        if (ServerEditHandler.isInEditmode(player)) {
            return false;
        }
        if (((Boolean)MinestuckConfig.SERVER.privateComputers.get()).booleanValue()) {
            return this.owner != null && this.owner.appliesTo((Player)player) || player.hasPermissions(2);
        }
        return true;
    }
}

