/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.OnCollisionTeleporterBlockEntity;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.world.GateHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GateBlockEntity
extends OnCollisionTeleporterBlockEntity<ServerPlayer> {
    public int color;
    public GateHandler.Type gateType;

    public GateBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.GATE.get(), pos, state, ServerPlayer.class);
    }

    @Override
    protected AABB getTeleportField() {
        return new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.4375, (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)this.worldPosition.getY() + 0.5625, (double)(this.worldPosition.getZ() + 1));
    }

    @Override
    protected void teleport(ServerPlayer player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GateHandler.teleport(this.gateType, serverLevel, player);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (nbt.contains("gate_type")) {
            this.gateType = GateHandler.Type.fromString(nbt.getString("gate_type"));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.gateType != null) {
            compound.putString("gate_type", this.gateType.toString());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.putInt("color", ColorHandler.getColorForDimension((ServerLevel)this.level));
        return nbt;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.color = tag.getInt("color");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }
}

