/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mraof.minestuck.block.machine.HolopadBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HolopadBlockEntity
extends BlockEntity {
    private int rotationTicks = 0;
    private ItemStack card = ItemStack.EMPTY;

    public HolopadBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.HOLOPAD.get(), pos, state);
    }

    public void onRightClick(Player player) {
        if (!this.card.isEmpty()) {
            this.takeItem(player);
        } else {
            this.insertHeldItem(player);
        }
    }

    private void takeItem(Player player) {
        if (player.getMainHandItem().isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, this.card);
        } else if (!player.getInventory().add(this.card)) {
            this.dropItem(false, this.level, this.worldPosition, this.card);
        } else {
            player.inventoryMenu.broadcastChanges();
        }
        this.card = ItemStack.EMPTY;
        this.updateState();
    }

    private void insertHeldItem(Player player) {
        ItemStack heldStack = player.getMainHandItem();
        if (this.card.isEmpty() && !heldStack.isEmpty() && heldStack.is(MSItems.CAPTCHA_CARD)) {
            this.card = heldStack.split(1);
            this.updateState();
        }
    }

    public void dropItem(boolean inBlock, Level level, BlockPos pos, ItemStack item) {
        BlockPos dropPos = inBlock ? pos : (!Block.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN) ? pos.above() : pos);
        Containers.dropItemStack((Level)level, (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), (ItemStack)item);
    }

    public boolean hasCard() {
        return !this.getCard().isEmpty();
    }

    public ItemStack getCard() {
        return this.card;
    }

    public ItemStack getHoloItem() {
        return EncodedItemComponent.getEncodedOrBlank(this.card);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.card = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound("card"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("card", this.card.saveOptional(provider));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.put("card", this.card.saveOptional(provider));
        return nbt;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int getRotationTickForRender() {
        return this.rotationTicks;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HolopadBlockEntity blockEntity) {
        ++blockEntity.rotationTicks;
    }

    private void updateState() {
        if (this.level != null && !this.level.isClientSide) {
            boolean hasCard;
            BlockState state = this.level.getBlockState(this.worldPosition);
            boolean bl = hasCard = !this.card.isEmpty();
            if (state.hasProperty((Property)HolopadBlock.HAS_CARD) && hasCard != (Boolean)state.getValue((Property)HolopadBlock.HAS_CARD)) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)HolopadBlock.HAS_CARD, (Comparable)Boolean.valueOf(hasCard)), 2);
            }
        }
    }
}

