/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mraof.minestuck.block.HorseClockBlock;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HorseClockBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private static final RawAnimation TICK_ANIMATION = RawAnimation.begin().thenLoop("ticktockontheclock");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hasChimed = false;

    public HorseClockBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.HORSE_CLOCK.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HorseClockBlockEntity blockEntity) {
        if (level != null && level.isAreaLoaded(pos, 1)) {
            if (level.getGameTime() % 40L == 0L) {
                blockEntity.sendUpdate(true);
            }
            if (level.getGameTime() % 40L == 20L) {
                blockEntity.sendUpdate(false);
            }
            if (level.getDayTime() % 24000L == 0L && HorseClockBlockEntity.isNotMuffled(blockEntity) && !blockEntity.hasChimed) {
                HorseClockBlockEntity.fullPower(level, blockEntity);
            }
        }
    }

    public static void fullPower(Level level, HorseClockBlockEntity blockEntity) {
        level.playSound(null, blockEntity.getBlockPos(), MSSoundEvents.BLOCK_HORSE_CLOCK_CHIME.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
        blockEntity.hasChimed = true;
        if (level.isAreaLoaded(blockEntity.getBlockPos(), 1)) {
            HorseClockBlockEntity.powerBlocks(blockEntity, 15);
        }
    }

    private void sendUpdate(boolean isTick) {
        if (!this.hasChimed) {
            HorseClockBlockEntity.powerBlocks(this, isTick ? 4 : 2);
        }
        if (HorseClockBlockEntity.isNotMuffled(this)) {
            if (isTick) {
                this.level.playSound(null, this.getBlockPos(), MSSoundEvents.BLOCK_CLOCK_TICK.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                this.level.playSound(null, this.getBlockPos(), MSSoundEvents.BLOCK_CLOCK_TOCK.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        if (this.level.getDayTime() % 24000L != 0L) {
            this.hasChimed = false;
        }
    }

    private static void powerBlocks(HorseClockBlockEntity blockEntity, int power) {
        BlockPos topPos;
        BlockState topState;
        Level level = blockEntity.level;
        BlockPos pos = blockEntity.getBlockPos();
        BlockState state = blockEntity.getBlockState();
        level.setBlock(pos, (BlockState)state.setValue((Property)HorseClockBlock.POWER, (Comparable)Integer.valueOf(power)), 3);
        BlockPos centerPos = pos.above();
        BlockState centerState = level.getBlockState(centerPos);
        if (centerState.is((Block)MSBlocks.HORSE_CLOCK.CENTER.get())) {
            level.setBlock(centerPos, (BlockState)centerState.setValue((Property)HorseClockBlock.POWER, (Comparable)Integer.valueOf(power)), 3);
        }
        if ((topState = level.getBlockState(topPos = pos.above(2))).is((Block)MSBlocks.HORSE_CLOCK.TOP.get())) {
            level.setBlock(topPos, (BlockState)topState.setValue((Property)HorseClockBlock.POWER, (Comparable)Integer.valueOf(power)), 3);
        }
        level.scheduleTick(new BlockPos((Vec3i)pos), level.getBlockState(pos).getBlock(), 10);
        level.scheduleTick(new BlockPos((Vec3i)centerPos), level.getBlockState(centerPos).getBlock(), 10);
        level.scheduleTick(new BlockPos((Vec3i)topPos), level.getBlockState(topPos).getBlock(), 10);
    }

    private static boolean isNotMuffled(HorseClockBlockEntity blockEntity) {
        return !blockEntity.level.getBlockState(blockEntity.getBlockPos().below()).is(BlockTags.OCCLUDES_VIBRATION_SIGNALS);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "pendulum", 0, this::pendulumAnimation));
    }

    private <E extends BlockEntity> PlayState pendulumAnimation(AnimationState<E> state) {
        state.getController().setAnimation(TICK_ANIMATION);
        return PlayState.CONTINUE;
    }
}

