/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class OnCollisionTeleporterBlockEntity<E extends Entity>
extends BlockEntity {
    private final Class<E> entityClass;
    private boolean hasCollision = false;

    public OnCollisionTeleporterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Class<E> entityClass) {
        super(type, pos, state);
        this.entityClass = entityClass;
    }

    protected boolean shouldTeleport(E entity) {
        return !entity.isPassenger() && !entity.isVehicle();
    }

    protected abstract AABB getTeleportField();

    protected abstract void teleport(E var1);

    public void onCollision(E entity) {
        if (!entity.level().isClientSide && this.shouldTeleport(entity)) {
            this.hasCollision = true;
        }
    }

    public static <E extends Entity> void serverTick(Level level, BlockPos pos, BlockState state, OnCollisionTeleporterBlockEntity<E> blockEntity) {
        if (blockEntity.hasCollision && level instanceof ServerLevel) {
            AABB boundingBox = blockEntity.getTeleportField();
            List entities = level.getEntitiesOfClass(blockEntity.entityClass, boundingBox, entity -> OnCollisionTeleporterBlockEntity.canTeleport(entity) && blockEntity.shouldTeleport((Entity)entity));
            for (Entity entity2 : entities) {
                if (entity2.isOnPortalCooldown()) {
                    entity2.setPortalCooldown();
                    continue;
                }
                blockEntity.teleport(entity2);
            }
            blockEntity.hasCollision = false;
        }
    }

    private static boolean canTeleport(Entity entity) {
        return !entity.noPhysics && entity.canUsePortal(false);
    }
}

