/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.OnCollisionTeleporterBlockEntity;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.util.Teleport;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public class ReturnNodeBlockEntity
extends OnCollisionTeleporterBlockEntity<ServerPlayer> {
    public int color;

    public ReturnNodeBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.RETURN_NODE.get(), pos, state, ServerPlayer.class);
    }

    @Override
    protected AABB getTeleportField() {
        return new AABB((double)(this.worldPosition.getX() - 1), (double)this.worldPosition.getY() + 0.4375, (double)(this.worldPosition.getZ() - 1), (double)(this.worldPosition.getX() + 1), (double)this.worldPosition.getY() + 0.5625, (double)(this.worldPosition.getZ() + 1));
    }

    @Override
    protected void teleport(ServerPlayer player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos spawnPos = serverLevel.getSharedSpawnPos();
            int spawnHeight = this.level.getChunk(spawnPos).getHeight(Heightmap.Types.MOTION_BLOCKING, spawnPos.getX(), spawnPos.getZ());
            BlockPos pos = new BlockPos(spawnPos.getX(), spawnHeight, spawnPos.getZ());
            Teleport.teleportEntity((Entity)player, serverLevel, (double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
            player.setPortalCooldown();
            player.setDeltaMovement(Vec3.ZERO);
            player.fallDistance = 0.0f;
            MSCriteriaTriggers.RETURN_NODE.get().trigger(player);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.putInt("color", ColorHandler.getColorForDimension((ServerLevel)this.level));
        return nbt;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.color = tag.getInt("color");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.handleUpdateTag(pkt.getTag(), provider);
    }
}

