/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mraof.minestuck.block.SkaiaBlocks;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.util.Teleport;
import com.mraof.minestuck.world.MSDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SkaiaPortalBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();

    public SkaiaPortalBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.SKAIA_PORTAL.get(), pos, state);
    }

    public void teleportEntity(Entity entity) {
        MinecraftServer server = entity.getServer();
        if (server == null || this.level == null) {
            return;
        }
        Entity newEntity = Teleport.teleportEntity(entity, server.getLevel(this.destinationDimension()), (double)this.worldPosition.getX() + 0.5, this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5);
        if (newEntity != null) {
            this.placeDestPlatform(newEntity.level());
            newEntity.setPortalCooldown();
        }
    }

    private void placeDestPlatform(Level level) {
        double x = this.worldPosition.getX();
        double y = this.worldPosition.getY();
        double z = this.worldPosition.getZ();
        Block[] blocks = new Block[]{SkaiaBlocks.BLACK_CHESS_DIRT.asBlock(), SkaiaBlocks.LIGHT_GRAY_CHESS_DIRT.asBlock(), SkaiaBlocks.WHITE_CHESS_DIRT.asBlock(), SkaiaBlocks.DARK_GRAY_CHESS_DIRT.asBlock()};
        int blockX = (int)x - 2;
        while ((double)blockX < x + 2.0) {
            int blockZ = (int)z - 2;
            while ((double)blockZ < z + 2.0) {
                level.setBlock(new BlockPos(blockX, (int)y - 1, blockZ), blocks[blockX + blockZ & 3].defaultBlockState(), 3);
                int blockY = (int)y;
                while ((double)blockY < y + 6.0) {
                    level.removeBlock(new BlockPos(blockX, blockY, blockZ), false);
                    ++blockY;
                }
                ++blockZ;
            }
            ++blockX;
        }
    }

    private ResourceKey<Level> destinationDimension() {
        return this.level != null && this.level.dimension() == MSDimensions.SKAIA ? Level.OVERWORLD : MSDimensions.SKAIA;
    }
}

