/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.OnCollisionTeleporterBlockEntity;
import com.mraof.minestuck.item.block.TransportalizerItem;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.MSParticleType;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.util.Teleport;
import com.mraof.minestuck.world.storage.TransportalizerSavedData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportalizerBlockEntity
extends OnCollisionTeleporterBlockEntity<Entity>
implements Nameable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DISABLED = "minestuck.transportalizer.disabled";
    public static final String BLOCKED = "minestuck.transportalizer.blocked";
    public static final String BLOCKED_DESTINATION = "minestuck.transportalizer.blocked_destination";
    public static final String FORBIDDEN = "minestuck.transportalizer.forbidden";
    public static final String FORBIDDEN_DESTINATION = "minestuck.transportalizer.forbidden_destination";
    public static final String TAKEN = "minestuck.transportalizer.taken";
    public static final String ID = "idString";
    public static final String DEST_ID = "destId";
    public static final String ACTIVE = "active";
    public static final String LOCKED = "locked";
    private boolean enabled = true;
    private boolean active = false;
    private boolean locked = false;
    private boolean unloaded = false;
    private String id = "";
    private String destId = "";

    public TransportalizerBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.TRANSPORTALIZER.get(), pos, state, Entity.class);
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (!this.level.isClientSide && this.active && this.hasId()) {
            this.active = TransportalizerSavedData.get(this.level).set(this.id, GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition));
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide && this.active && !this.unloaded) {
            TransportalizerSavedData.get(this.level).remove(this.id, GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition));
        }
    }

    public static void transportalizerTick(Level level, BlockPos pos, BlockState state, TransportalizerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (level.hasNeighborSignal(blockEntity.getBlockPos())) {
            if (blockEntity.enabled) {
                blockEntity.setEnabled(false);
            }
        } else if (!blockEntity.enabled) {
            blockEntity.setEnabled(true);
        }
        TransportalizerBlockEntity.serverTick(level, pos, state, blockEntity);
    }

    @Override
    protected AABB getTeleportField() {
        return new AABB((double)this.worldPosition.getX() + 0.0625, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.0625, (double)this.worldPosition.getX() + 0.9375, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.9375);
    }

    @Override
    protected void teleport(Entity entity) {
        if (this.level == null) {
            return;
        }
        GlobalPos destination = TransportalizerSavedData.get(this.level).get(this.destId);
        if (!this.enabled) {
            entity.setPortalCooldown();
            if (entity instanceof ServerPlayer) {
                entity.sendSystemMessage((Component)Component.translatable((String)DISABLED));
            }
            return;
        }
        if (destination != null && entity.getServer() != null) {
            ServerLevel destinationLevel = entity.getServer().getLevel(destination.dimension());
            if (destinationLevel == null) {
                LOGGER.warn("Transportalizer at invalid dimension in map: {} at {}", (Object)this.destId, (Object)destination);
                TransportalizerSavedData.get(this.level).remove(this.destId, destination);
                this.destId = "";
                return;
            }
            BlockEntity blockEntity = destinationLevel.getBlockEntity(destination.pos());
            if (!(blockEntity instanceof TransportalizerBlockEntity)) {
                LOGGER.warn("Invalid transportalizer in map: {} at {}", (Object)this.destId, (Object)destination);
                TransportalizerSavedData.get(this.level).remove(this.destId, destination);
                this.destId = "";
                return;
            }
            TransportalizerBlockEntity destTransportalizer = (TransportalizerBlockEntity)blockEntity;
            if (!destTransportalizer.getEnabled()) {
                return;
            }
            if (TransportalizerBlockEntity.isDimensionForbidden(this.level)) {
                entity.setPortalCooldown();
                if (entity instanceof ServerPlayer) {
                    entity.sendSystemMessage((Component)Component.translatable((String)FORBIDDEN));
                }
                return;
            }
            if (TransportalizerBlockEntity.isDimensionForbidden((Level)destinationLevel)) {
                entity.setPortalCooldown();
                if (entity instanceof ServerPlayer) {
                    entity.sendSystemMessage((Component)Component.translatable((String)FORBIDDEN_DESTINATION));
                }
                return;
            }
            if (TransportalizerBlockEntity.isBlocked(this.level, this.worldPosition)) {
                entity.setPortalCooldown();
                if (entity instanceof ServerPlayer) {
                    entity.sendSystemMessage((Component)Component.translatable((String)BLOCKED));
                }
                return;
            }
            if (TransportalizerBlockEntity.isBlocked((Level)destinationLevel, destination.pos())) {
                entity.setPortalCooldown();
                if (entity instanceof ServerPlayer) {
                    entity.sendSystemMessage((Component)Component.translatable((String)BLOCKED_DESTINATION));
                }
                return;
            }
            ServerLevel originLevel = (ServerLevel)this.level;
            if ((entity = Teleport.teleportEntity(entity, (ServerLevel)destTransportalizer.level, (double)destination.pos().getX() + 0.5, (double)destination.pos().getY() + 0.6, (double)destination.pos().getZ() + 0.5, entity.getYRot(), entity.getXRot())) != null) {
                entity.setPortalCooldown();
                if (originLevel != null) {
                    originLevel.sendParticles((ParticleOptions)MSParticleType.TRANSPORTALIZER.get(), (double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.level.playSound(null, this.getBlockPos(), MSSoundEvents.TRANSPORTALIZER_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                destinationLevel.sendParticles((ParticleOptions)MSParticleType.TRANSPORTALIZER.get(), (double)destination.pos().getX() + 0.5, (double)(destination.pos().getY() + 1), (double)destination.pos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean isBlocked(Level level, BlockPos pos) {
        BlockState block0 = level.getBlockState(pos.above());
        BlockState block1 = level.getBlockState(pos.above(2));
        return block0.blocksMotion() || block1.blocksMotion();
    }

    private static boolean isDimensionForbidden(Level level) {
        List forbiddenWorlds = (List)MinestuckConfig.SERVER.forbiddenWorldsTpz.get();
        List forbiddenDimTypes = (List)MinestuckConfig.SERVER.forbiddenDimensionTypesTpz.get();
        Optional typeKey = level.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getResourceKey((Object)level.dimensionType());
        return forbiddenWorlds.contains(String.valueOf(level.dimension().location())) || typeKey.isPresent() && forbiddenDimTypes.contains(String.valueOf(((ResourceKey)typeKey.get()).location()));
    }

    public boolean hasId() {
        return !this.id.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public void trySetId(String id, Player player) {
        if (this.level == null || this.level.isClientSide || this.locked || this.hasId() || id.isEmpty()) {
            return;
        }
        if (TransportalizerSavedData.get(this.level).get(id) != null) {
            player.sendSystemMessage((Component)Component.translatable((String)TAKEN, (Object[])new Object[]{id}));
        } else {
            this.setId(id);
        }
    }

    public void setId(String id) {
        if (this.level == null || this.level.isClientSide || this.locked || this.hasId() || id.isEmpty()) {
            return;
        }
        this.id = id;
        GlobalPos location = GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition);
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.active = TransportalizerSavedData.get(this.level).set(id, location);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 0);
    }

    public String getDestId() {
        return this.destId;
    }

    public void setDestId(String destId) {
        if (this.locked) {
            return;
        }
        this.destId = destId;
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 0);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public void tryReactivate() {
        this.active = TransportalizerSavedData.get(this.level).set(this.id, GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 0);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public Component getName() {
        return Component.literal((String)"Transportalizer");
    }

    public Component getDisplayName() {
        return this.hasCustomName() ? this.getCustomName() : this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.id.isEmpty() ? null : Component.literal((String)this.id);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.destId = nbt.getString(DEST_ID);
        this.id = nbt.getString(ID);
        if (nbt.contains(ACTIVE)) {
            this.active = nbt.getBoolean(ACTIVE);
        }
        this.locked = nbt.getBoolean(LOCKED);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (!this.id.isEmpty()) {
            compound.putString(ID, this.id);
        }
        if (!this.destId.isEmpty()) {
            compound.putString(DEST_ID, this.destId);
        }
        compound.putBoolean(ACTIVE, this.active);
        compound.putBoolean(LOCKED, this.locked);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        TransportalizerItem.TransportalizerData data = (TransportalizerItem.TransportalizerData)componentInput.get(MSItemComponents.TRANSPORTALIZER_DATA);
        if (data != null) {
            this.id = data.id().orElse("");
            this.destId = data.destinationId().orElse("");
            this.locked = data.locked();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(MSItemComponents.TRANSPORTALIZER_DATA, (Object)new TransportalizerItem.TransportalizerData(this.id.isEmpty() ? Optional.empty() : Optional.of(this.id), this.destId.isEmpty() ? Optional.empty() : Optional.of(this.destId), this.locked));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

