/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.block.EnumDowelType;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.machine.AlchemiterBlock;
import com.mraof.minestuck.blockentity.IColored;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.GristWildcardHolder;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.event.AlchemyEvent;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.util.MSParticleType;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AlchemiterBlockEntity
extends BlockEntity
implements IColored,
GristWildcardHolder,
GeoBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RawAnimation SCAN_ANIMATION = RawAnimation.begin().then("scan", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private GristType wildcardGrist = GristTypes.BUILD.get();
    protected boolean broken = false;
    protected ItemStack dowel = ItemStack.EMPTY;

    public AlchemiterBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.ALCHEMITER.get(), pos, state);
    }

    public void setDowel(ItemStack newDowel) {
        if (newDowel.getItem() == ((Block)MSBlocks.CRUXITE_DOWEL.get()).asItem() || newDowel.isEmpty()) {
            BlockState state;
            this.dowel = newDowel;
            this.setChanged();
            if (this.level != null && (state = this.level.getBlockState(this.worldPosition)).hasProperty(AlchemiterBlock.Pad.DOWEL)) {
                state = (BlockState)state.setValue(AlchemiterBlock.Pad.DOWEL, (Comparable)((Object)EnumDowelType.getForDowel(newDowel)));
                this.level.setBlock(this.worldPosition, state, 2);
            }
        }
        this.requestModelDataUpdate();
    }

    public ItemStack getDowel() {
        return this.dowel;
    }

    @Override
    public int getColor() {
        return ColorHandler.getColorFromStack(this.dowel);
    }

    public ItemStack getOutput() {
        return EncodedItemComponent.getEncodedOrBlank(this.dowel);
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void breakMachine() {
        this.broken = true;
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        }
    }

    public void unbreakMachine() {
        this.broken = false;
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        }
    }

    public void dropItem(@Nullable Direction direction) {
        BlockPos dropPos;
        if (this.level == null) {
            LOGGER.warn("Tried to drop alchemiter dowel before the block entity was given a world!");
            return;
        }
        BlockPos blockPos = dropPos = direction == null ? this.worldPosition : this.worldPosition.relative(direction);
        if (direction != null && Block.canSupportCenter((LevelReader)this.level, (BlockPos)this.worldPosition.relative(direction), (Direction)direction.getOpposite())) {
            dropPos = this.worldPosition;
        }
        Containers.dropItemStack((Level)this.level, (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), (ItemStack)this.dowel);
        this.setDowel(ItemStack.EMPTY);
    }

    private boolean isUseable(BlockState state) {
        if (!this.broken) {
            this.checkStates();
            if (this.broken) {
                LOGGER.warn("Failed to notice a block being broken or misplaced at the alchemiter at {}", (Object)this.getBlockPos());
            }
        }
        return !this.broken;
    }

    public void checkStates() {
        if (this.broken || this.level == null) {
            return;
        }
        if (MSBlocks.ALCHEMITER.isInvalidFromPad((LevelAccessor)this.level, this.worldPosition)) {
            this.breakMachine();
        }
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)AlchemiterBlock.FACING);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.wildcardGrist = GristHelper.parseGristType(nbt.get("gristType")).orElseGet(GristTypes.BUILD);
        this.broken = nbt.getBoolean("broken");
        ItemStack oldDowel = this.dowel;
        this.dowel = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound("dowel"));
        if (this.level != null && this.level.isClientSide && !ItemStack.matches((ItemStack)oldDowel, (ItemStack)this.dowel)) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 8);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("gristType", GristHelper.encodeGristType(this.wildcardGrist));
        compound.putBoolean("broken", this.isBroken());
        compound.put("dowel", this.dowel.saveOptional(provider));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onRightClick(Level level, Player playerIn, BlockState state, Direction side) {
        if (level.isClientSide) {
            if (state.getBlock() == MSBlocks.ALCHEMITER.CENTER.get() || state.getBlock() == MSBlocks.ALCHEMITER.CORNER.get() || state.getBlock() == MSBlocks.ALCHEMITER.LEFT_SIDE.get() || state.getBlock() == MSBlocks.ALCHEMITER.RIGHT_SIDE.get() || state.getBlock() == MSBlocks.ALCHEMITER.TOTEM_CORNER.get()) {
                BlockPos mainPos = this.worldPosition;
                if (!this.isBroken()) {
                    MSScreenFactories.displayAlchemiterScreen(this);
                }
            }
            return;
        }
        this.onPadRightClick(playerIn, state, side);
    }

    public void onPadRightClick(Player player, BlockState clickedState, Direction side) {
        if (this.isUseable(clickedState) && clickedState.getBlock() == MSBlocks.ALCHEMITER.TOTEM_PAD.get()) {
            if (!this.dowel.isEmpty()) {
                if (player.getMainHandItem().isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, this.dowel);
                } else if (!player.getInventory().add(this.dowel)) {
                    this.dropItem(side);
                } else {
                    player.inventoryMenu.broadcastChanges();
                }
                this.setDowel(ItemStack.EMPTY);
            } else {
                ItemStack heldStack = player.getMainHandItem();
                if (!heldStack.isEmpty() && heldStack.getItem() == ((Block)MSBlocks.CRUXITE_DOWEL.get()).asItem()) {
                    this.setDowel(heldStack.split(1));
                }
            }
        }
    }

    public void processContents(int quantity, ServerPlayer player) {
        if (this.isBroken()) {
            return;
        }
        ItemStack newItem = this.getOutput();
        quantity = Math.min(newItem.getMaxStackSize() * (Integer)MinestuckConfig.SERVER.alchemiterMaxStacks.get(), Math.max(1, quantity));
        Direction facing = (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)AlchemiterBlock.FACING);
        BlockPos spawnPos = this.getBlockPos().relative(facing.getOpposite()).relative(facing.getCounterClockWise());
        if (facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
            spawnPos = spawnPos.relative(facing.getOpposite());
        }
        if (facing.getClockWise().getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
            spawnPos = spawnPos.relative(facing.getCounterClockWise());
        }
        GristSet cost = this.getGristCost(quantity);
        if (GristCache.get(player).tryTake(cost, GristHelper.EnumSource.CLIENT)) {
            AlchemyEvent event = new AlchemyEvent(IdentifierHandler.encode((Player)player), this, this.getDowel(), newItem, cost);
            NeoForge.EVENT_BUS.post((Event)event);
            newItem = event.getItemResult();
            while (quantity > 0) {
                ServerLevel blockLevel = (ServerLevel)this.level;
                ItemStack stack = newItem.copy();
                stack.setCount(Math.min(stack.getMaxStackSize(), quantity));
                quantity -= stack.getCount();
                ItemEntity item = new ItemEntity(this.level, (double)spawnPos.getX(), (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ(), stack);
                this.level.addFreshEntity((Entity)item);
                if (blockLevel != null) {
                    blockLevel.sendParticles((ParticleOptions)MSParticleType.PLASMA.get(), (double)spawnPos.getX(), (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.level.playSound(null, this.getBlockPos(), MSSoundEvents.ALCHEMITER_RESONATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Nullable
    public GristSet getGristCost(int quantity) {
        ItemStack dowel = this.getDowel();
        ItemStack stack = this.getOutput();
        if (dowel.isEmpty() || this.level == null) {
            return null;
        }
        stack.setCount(quantity);
        return GristCostRecipe.findCostForItem(stack, this.getWildcardGrist(), false, this.level);
    }

    public GristType getWildcardGrist() {
        return this.wildcardGrist;
    }

    @Override
    public void setWildcardGrist(GristType wildcardGrist) {
        if (this.wildcardGrist != wildcardGrist) {
            this.wildcardGrist = wildcardGrist;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "scanAnimation", 0, this::scanAnimation));
    }

    private <E extends BlockEntity> PlayState scanAnimation(AnimationState<E> state) {
        if (!this.dowel.isEmpty()) {
            state.getController().setAnimation(SCAN_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }
}

