/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.UraniumPowered;
import com.mraof.minestuck.inventory.AnthvilMenu;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.util.ExtraModTags;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class AnthvilBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider,
UraniumPowered {
    public static final String TITLE = "container.minestuck.anthvil";
    public static final short MAX_FUEL = 128;
    public static final short MEND_FUEL_COST = 5;
    private short fuel = 0;
    private final DataSlot fuelHolder = new DataSlot(){

        public int get() {
            return AnthvilBlockEntity.this.fuel;
        }

        public void set(int value) {
            AnthvilBlockEntity.this.fuel = (short)value;
        }
    };

    public AnthvilBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.ANTHVIL.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.fuel = compound.getShort("fuel");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putShort("fuel", this.fuel);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(this, 2, (index, stack) -> index == 0 || stack.is(ExtraModTags.Items.URANIUM_CHUNKS));
    }

    @Override
    protected void tick() {
    }

    public static void attemptMendAndRefuel(AnthvilBlockEntity anthvil, ServerPlayer player) {
        GristSet.Immutable pickedGrist;
        Level level = anthvil.level;
        ItemStackHandler itemHandler = anthvil.itemHandler;
        ItemStack slotStack = itemHandler.getStackInSlot(0);
        GristCache playerCache = GristCache.get(player);
        if (level == null || !AnthvilBlockEntity.isMendableItem(slotStack)) {
            return;
        }
        if (anthvil.canBeRefueled() && itemHandler.getStackInSlot(1).is(ExtraModTags.Items.URANIUM_CHUNKS)) {
            anthvil.addFuel((short)32);
            itemHandler.extractItem(1, 1, false);
        }
        if ((pickedGrist = AnthvilBlockEntity.mendingGrist(level, slotStack)).isEmpty() || !AnthvilBlockEntity.hasEnoughFuel(anthvil)) {
            return;
        }
        if (player.isCreative() || playerCache.tryTake(pickedGrist, GristHelper.EnumSource.CLIENT)) {
            int repairAmount = (int)(10.0 * pickedGrist.asAmounts().get(0).getValue());
            slotStack.setDamageValue(slotStack.getDamageValue() - repairAmount);
            if (!player.isCreative()) {
                anthvil.fuel = (short)(anthvil.fuel - 5);
            }
        }
    }

    private static boolean isMendableItem(ItemStack slotStack) {
        return !slotStack.isEmpty() && slotStack.isRepairable() && slotStack.isDamageableItem() && slotStack.isDamaged();
    }

    private static boolean hasEnoughFuel(AnthvilBlockEntity anthvil) {
        return anthvil.fuel >= 5;
    }

    private static GristSet.Immutable mendingGrist(Level level, ItemStack slotStack) {
        GristSet fullSet = GristCostRecipe.findCostForItem(slotStack, null, false, level);
        if (fullSet != null && !fullSet.isEmpty()) {
            return AnthvilBlockEntity.getUsedGrist(fullSet);
        }
        return GristSet.EMPTY;
    }

    public static GristAmount getUsedGrist(GristSet fullSet) {
        GristType pickedGrist = fullSet.asAmounts().stream().max(Comparator.comparingDouble(AnthvilBlockEntity::getModifiedGristValue)).map(GristAmount::type).orElse(GristTypes.BUILD.get());
        return pickedGrist.amount(1L);
    }

    private static double getModifiedGristValue(GristAmount grist) {
        double gristValue = Math.abs(grist.getValue());
        if (grist.type() == GristTypes.BUILD.get()) {
            gristValue /= 10.0;
        }
        return gristValue;
    }

    public boolean canBeRefueled() {
        return this.fuel <= 96;
    }

    @Override
    public void addFuel(short fuelAmount) {
        this.fuel = (short)(this.fuel + fuelAmount);
    }

    @Override
    public boolean atMaxFuel() {
        return this.fuel >= 128;
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.UP) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1);
        }
        if (side == Direction.DOWN) {
            return null;
        }
        return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new AnthvilMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.fuelHolder, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }
}

