/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.CruxiteDowelBlock;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class CruxtruderBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String EMPTY = "block.minestuck.cruxtruder.empty";
    private static final int CRUXITE_CAPACITY = 64;
    private int color = -1;
    private boolean isBroken = false;
    private int material = 0;

    public CruxtruderBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.CRUXTRUDER.get(), pos, state);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int Color) {
        this.color = Color;
    }

    public void setBroken() {
        this.isBroken = true;
        this.setChanged();
    }

    private void checkIfValid() {
        if (this.isBroken || this.level == null) {
            return;
        }
        if (MSBlocks.CRUXTRUDER.isInvalidFromTube((LevelAccessor)this.level, this.getBlockPos())) {
            this.setBroken();
            LOGGER.warn("Failed to notice a block being changed until afterwards at the cruxtruder at {}", (Object)this.getBlockPos());
        }
    }

    private void setMaterial(int material) {
        this.material = material;
        this.setChanged();
    }

    public void dropItems() {
        if (this.material > 0) {
            BlockPos pos = this.getBlockPos();
            Containers.dropItemStack((Level)Objects.requireNonNull(this.level), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)MSItems.RAW_CRUXITE.get(), this.material));
            this.setMaterial(0);
        }
    }

    public void onRightClick(Player player, boolean top) {
        this.checkIfValid();
        if (!this.isBroken && this.level != null) {
            BlockPos pos = this.getBlockPos().above();
            BlockState state = this.level.getBlockState(pos);
            if (top && ((Boolean)MinestuckConfig.SERVER.cruxtruderIntake.get()).booleanValue() && state.isAir() && -1 < this.material && this.material < 64) {
                ItemStack stack = player.getMainHandItem();
                if (!stack.is((Item)MSItems.RAW_CRUXITE.get())) {
                    stack = player.getOffhandItem();
                }
                if (stack.is((Item)MSItems.RAW_CRUXITE.get())) {
                    int count = 1;
                    if (player.isShiftKeyDown()) {
                        count = Math.min(64 - this.material, stack.getCount());
                    }
                    if (!player.isCreative()) {
                        stack.shrink(count);
                    }
                    this.setMaterial(this.material + count);
                    this.level.playSound(null, pos, MSSoundEvents.CRUXTRUDER_DOWEL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else if (!top) {
                if (state.is((Block)MSBlocks.EMERGING_CRUXITE_DOWEL.get())) {
                    CruxiteDowelBlock.dropDowel(this.level, pos);
                } else if (state.isAir()) {
                    if (((Boolean)MinestuckConfig.SERVER.cruxtruderIntake.get()).booleanValue() && this.material == 0) {
                        this.level.levelEvent(1001, pos, 0);
                        player.sendSystemMessage((Component)Component.translatable((String)EMPTY));
                    } else {
                        this.level.setBlockAndUpdate(pos, ((Block)MSBlocks.EMERGING_CRUXITE_DOWEL.get()).defaultBlockState());
                        this.level.playSound(null, pos, MSSoundEvents.CRUXTRUDER_DOWEL.get(), SoundSource.BLOCKS, 1.0f, 1.75f);
                        BlockEntity blockEntity = this.level.getBlockEntity(pos);
                        if (blockEntity instanceof ItemStackBlockEntity) {
                            ItemStackBlockEntity blockEntity2 = (ItemStackBlockEntity)blockEntity;
                            ColorHandler.setColor(blockEntity2.getStack(), this.color);
                        } else {
                            LOGGER.warn("Did not find block entity for setting cruxite color after placing cruxtruder dowel at {}", (Object)pos);
                        }
                        if (0 < this.material) {
                            this.setMaterial(this.material - 1);
                        }
                    }
                }
            }
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (nbt.contains("color")) {
            this.color = nbt.getInt("color");
        }
        this.isBroken = nbt.getBoolean("broken");
        this.material = nbt.getInt("material");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("color", this.color);
        compound.putBoolean("broken", this.isBroken);
        compound.putInt("material", this.material);
    }
}

