/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.block.machine.GristCollectorBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.entity.item.GristEntity;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class GristCollectorBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private MutableGristSet storedGrist = MutableGristSet.newDefault();

    public GristCollectorBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.GRIST_COLLECTOR.get(), pos, state);
    }

    public GristSet getStoredGrist() {
        return this.storedGrist.asImmutable();
    }

    public void addGristAmount(GristAmount gristAmount) {
        this.storedGrist.add(gristAmount);
        this.setChanged();
    }

    public void clearStoredGrist() {
        this.storedGrist = MutableGristSet.newDefault();
        this.setChanged();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.storedGrist = MutableGristSet.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("storedGrist")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(MutableGristSet::newDefault);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        MutableGristSet.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.storedGrist).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compound.put("storedGrist", tag));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GristCollectorBlockEntity blockEntity) {
        AABB aabb;
        List gristList;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getGameTime() % 10L == 0L && blockEntity != null && !((Boolean)state.getValue((Property)GristCollectorBlock.POWERED)).booleanValue() && !(gristList = level.getEntitiesOfClass(GristEntity.class, aabb = new AABB(pos).inflate(1.0))).isEmpty()) {
            for (GristEntity iteratedGrist : gristList) {
                GristAmount gristAmount = iteratedGrist.getAmount();
                if (gristAmount == null || !(gristAmount.getValue() >= 0.0)) continue;
                blockEntity.addGristAmount(gristAmount);
                iteratedGrist.discard();
            }
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.1f, 0.5f * ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.8f));
        }
    }
}

