/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.block.machine.GristWidgetBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.IOwnable;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.ProgressTracker;
import com.mraof.minestuck.entity.item.GristEntity;
import com.mraof.minestuck.inventory.GristWidgetMenu;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.CardStoredItemComponent;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
public class GristWidgetBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider,
IOwnable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TITLE = "container.minestuck.grist_widget";
    public static final int MAX_PROGRESS = 100;
    private final ProgressTracker progressTracker = new ProgressTracker(ProgressTracker.RunType.ONCE_OR_LOOPING, 100, () -> ((GristWidgetBlockEntity)this).setChanged(), this::contentsValid);
    @Nullable
    private PlayerIdentifier owner;

    public GristWidgetBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.GRIST_WIDGET.get(), pos, state);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(1, (slot, stack) -> stack.is(MSItems.CAPTCHA_CARD)){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                GristWidgetBlockEntity.this.checkAndUpdateState();
            }
        };
    }

    private void checkAndUpdateState() {
        Objects.requireNonNull(this.level);
        boolean hasCard = !this.itemHandler.getStackInSlot(0).isEmpty();
        BlockState newState = (BlockState)this.getBlockState().setValue((Property)GristWidgetBlock.HAS_CARD, (Comparable)Boolean.valueOf(hasCard));
        if (newState != this.getBlockState()) {
            this.level.setBlock(this.getBlockPos(), newState, 2);
        }
    }

    @Nullable
    public GristSet getGristWidgetResult() {
        return GristWidgetBlockEntity.getGristWidgetResult(this.itemHandler.getStackInSlot(0), this.level);
    }

    @Nullable
    public static GristSet getGristWidgetResult(ItemStack stack, Level level) {
        if (level == null) {
            return null;
        }
        if (!CaptchaCardItem.isUnpunchedCard(stack)) {
            return null;
        }
        ItemStack containedItem = CardStoredItemComponent.getContainedRealItem(stack);
        if (containedItem.isEmpty()) {
            return null;
        }
        return GristCostRecipe.findCostForItem(containedItem, null, true, level);
    }

    public int getGristWidgetBoondollarValue() {
        return GristWidgetBlockEntity.getGristWidgetBoondollarValue(this.getGristWidgetResult());
    }

    public static int getGristWidgetBoondollarValue(GristSet set) {
        return set == null ? 0 : Math.max(1, (int)Math.pow(set.getValue(), 0.6666666666666666));
    }

    @Override
    protected void tick() {
        this.progressTracker.tick(this::processContents);
    }

    private boolean contentsValid() {
        if (((Boolean)MinestuckConfig.SERVER.disableGristWidget.get()).booleanValue()) {
            return false;
        }
        if (this.level.hasNeighborSignal(this.getBlockPos())) {
            return false;
        }
        int i = this.getGristWidgetBoondollarValue();
        return this.owner != null && i != 0 && (long)i <= PlayerBoondollars.getBoondollars(PlayerData.get(this.owner, this.level));
    }

    private void processContents() {
        GristSet gristSet = this.getGristWidgetResult();
        if (gristSet == null) {
            return;
        }
        if (!PlayerBoondollars.tryTakeBoondollars(PlayerData.get(this.owner, this.level), this.getGristWidgetBoondollarValue())) {
            LOGGER.warn("Failed to remove boondollars for a grist widget from {}'s porkhollow", (Object)this.owner.getUsername());
            return;
        }
        GristEntity.spawnGristEntities(gristSet, this.level, (double)this.worldPosition.getX() + 0.5, this.worldPosition.getY() + 1, (double)this.worldPosition.getZ() + 0.5, this.level.random, entity -> entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, 0.5, 0.5)));
        this.itemHandler.extractItem(0, 1, false);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.progressTracker.load(nbt);
        this.owner = IdentifierHandler.load(nbt, "owner").result().orElse(null);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.progressTracker.save(compound);
        if (this.owner != null) {
            this.owner.saveToNBT(compound, "owner");
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new GristWidgetMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.progressTracker, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.worldPosition);
    }

    @Override
    public void setOwner(PlayerIdentifier identifier) {
        this.owner = identifier;
    }

    @Override
    @Nullable
    public PlayerIdentifier getOwner() {
        return this.owner;
    }

    public IItemHandler getItemHandler(@Nullable Direction ignored) {
        return this.itemHandler;
    }
}

