/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.block.machine.IntellibeamLaserstationBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.CaptchaCodeComponent;
import com.mraof.minestuck.item.components.CardStoredItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.util.MSTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
public class IntellibeamLaserstationBlockEntity
extends BlockEntity {
    public static final String DECODING_PROGRESS = "block.minestuck.intellibeam_laserstation.decoding_progress";
    public static final String CAPTCHA_DECODED = "block.minestuck.intellibeam_laserstation.captcha_decoded";
    private static final int EXP_LEVEL_CAPACITY = 10;
    private final Map<Item, Integer> decodingProgress = new HashMap<Item, Integer>();
    private ItemStack analyzedCard = ItemStack.EMPTY;
    private int waitTimer = 0;

    public IntellibeamLaserstationBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.INTELLIBEAM_LASERSTATION.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, IntellibeamLaserstationBlockEntity intellibeam) {
        if (intellibeam.waitTimer > 0) {
            --intellibeam.waitTimer;
        }
    }

    public void onRightClick(Player player) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.waitTimer > 0) {
            return;
        }
        this.waitTimer = 10;
        if (this.analyzedCard.isEmpty()) {
            ItemStack heldCard = player.getMainHandItem();
            ItemStack itemInHeldCard = ((CardStoredItemComponent)heldCard.getOrDefault(MSItemComponents.CARD_STORED_ITEM, (Object)CardStoredItemComponent.EMPTY)).storedStack();
            if (itemInHeldCard.is(MSTags.Items.UNREADABLE)) {
                this.setCard(heldCard.split(1));
            }
            return;
        }
        if (player.isShiftKeyDown()) {
            this.takeCard(player);
            return;
        }
        if (this.analyzedCard.has(MSItemComponents.CAPTCHA_CODE)) {
            this.level.playSound(null, this.worldPosition, MSSoundEvents.INTELLIBEAM_LASERSTATION_REMOVE_CARD.get(), SoundSource.BLOCKS, 0.5f, 0.1f);
            player.displayClientMessage((Component)Component.translatable((String)CAPTCHA_DECODED), true);
            return;
        }
        if (this.getCardItemExperience() < 10) {
            this.addExperience(player);
            return;
        }
        CardStoredItemComponent analyzedCardComponent = (CardStoredItemComponent)this.analyzedCard.getOrDefault(MSItemComponents.CARD_STORED_ITEM, (Object)CardStoredItemComponent.EMPTY);
        MSCriteriaTriggers.INTELLIBEAM_LASERSTATION.get().trigger((ServerPlayer)player, analyzedCardComponent.storedStack());
        this.setReadable(this.analyzedCard, serverLevel.getServer());
        this.takeCard(player);
    }

    private Integer getCardItemExperience() {
        return this.decodingProgress.getOrDefault(((CardStoredItemComponent)this.analyzedCard.getOrDefault(MSItemComponents.CARD_STORED_ITEM, (Object)CardStoredItemComponent.EMPTY)).storedStack().getItem(), 0);
    }

    public String processExperienceGuage() {
        int numberOfBars = "\u25af\u25af\u25af\u25af\u25af\u25af\u25af\u25af\u25af\u25af".length();
        char[] stringChars = new char[numberOfBars];
        for (int i = 0; i < numberOfBars; ++i) {
            stringChars[i] = i < this.getCardItemExperience() ? 9646 : 9647;
        }
        return "<" + new String(stringChars) + ">";
    }

    public void takeCard(Player player) {
        if (player.getMainHandItem().isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, this.analyzedCard);
        } else if (!player.getInventory().add(this.analyzedCard)) {
            this.dropCard(false, this.level, this.worldPosition, this.analyzedCard);
        } else {
            player.inventoryMenu.broadcastChanges();
        }
        this.level.playSound(null, this.worldPosition, MSSoundEvents.INTELLIBEAM_LASERSTATION_REMOVE_CARD.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.setCard(ItemStack.EMPTY);
    }

    public void dropCard(boolean inBlock, Level level, BlockPos pos, ItemStack item) {
        BlockPos dropPos = inBlock ? pos : (!Block.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN) ? pos.above() : pos);
        Containers.dropItemStack((Level)level, (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), (ItemStack)item);
    }

    public void setCard(ItemStack card) {
        if (card.is((Item)MSItems.CAPTCHA_CARD.get()) || card.isEmpty()) {
            this.analyzedCard = card;
            if (this.level != null) {
                this.updateState();
            }
        }
    }

    public void setReadable(ItemStack taggedCard, MinecraftServer mcServer) {
        CardStoredItemComponent storedItem = (CardStoredItemComponent)taggedCard.get(MSItemComponents.CARD_STORED_ITEM);
        if (storedItem != null) {
            taggedCard.set(MSItemComponents.CAPTCHA_CODE, (Object)CaptchaCodeComponent.createFor(storedItem.storedStack(), mcServer));
        }
    }

    public void addExperience(Player player) {
        if (player.experienceLevel <= 0 && !player.isCreative()) {
            return;
        }
        if (player.getMainHandItem().isEmpty() && !this.analyzedCard.isEmpty()) {
            if (!player.isCreative()) {
                player.giveExperienceLevels(-1);
            }
            Item analyzedItem = ((CardStoredItemComponent)this.analyzedCard.getOrDefault(MSItemComponents.CARD_STORED_ITEM, (Object)CardStoredItemComponent.EMPTY)).storedStack().getItem();
            int storedExperience = this.decodingProgress.getOrDefault(analyzedItem, 0);
            this.decodingProgress.put(analyzedItem, storedExperience + 1);
            float soundScale = (float)storedExperience / 10.0f;
            this.level.playSound(null, this.worldPosition, MSSoundEvents.INTELLIBEAM_LASERSTATION_EXP_GATHER.get(), SoundSource.BLOCKS, 0.5f, 1.0f + soundScale);
            player.displayClientMessage((Component)Component.translatable((String)DECODING_PROGRESS, (Object[])new Object[]{this.processExperienceGuage()}), true);
        }
    }

    public ItemStack getAnalyzedCard() {
        return this.analyzedCard;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.setCard(ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound("card")));
        CompoundTag progressData = nbt.getCompound("decoding_progress");
        for (String itemName : progressData.getAllKeys()) {
            Item item;
            ResourceLocation itemId = ResourceLocation.tryParse((String)itemName);
            if (itemId == null || (item = (Item)BuiltInRegistries.ITEM.get(itemId)) == null) continue;
            this.decodingProgress.put(item, progressData.getInt(itemName));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("card", this.analyzedCard.saveOptional(provider));
        CompoundTag progressData = new CompoundTag();
        for (Map.Entry<Item, Integer> entry : this.decodingProgress.entrySet()) {
            String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)entry.getKey())).toString();
            progressData.putInt(itemName, entry.getValue().intValue());
        }
        compound.put("decoding_progress", (Tag)progressData);
    }

    private void updateState() {
        if (this.level != null && !this.level.isClientSide) {
            boolean hasCard;
            BlockState state = this.level.getBlockState(this.worldPosition);
            boolean bl = hasCard = !this.analyzedCard.isEmpty();
            if (state.hasProperty((Property)IntellibeamLaserstationBlock.HAS_CARD) && hasCard != (Boolean)state.getValue((Property)IntellibeamLaserstationBlock.HAS_CARD)) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)IntellibeamLaserstationBlock.HAS_CARD, (Comparable)Boolean.valueOf(hasCard)), 2);
            }
        }
    }
}

