/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class MachineProcessBlockEntity
extends BlockEntity {
    protected final ItemStackHandler itemHandler = this.createItemHandler();
    public static final int FUEL_INCREASE = 32;

    protected MachineProcessBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected abstract ItemStackHandler createItemHandler();

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
    }

    public static void serverTick(Level ignoredLevel, BlockPos ignoredPos, BlockState ignoredState, MachineProcessBlockEntity blockEntity) {
        blockEntity.tick();
    }

    protected abstract void tick();

    protected class CustomHandler
    extends ItemStackHandler {
        private final BiPredicate<Integer, ItemStack> isValidPredicate;

        protected CustomHandler(int size) {
            this(size, (slot, stack) -> true);
        }

        protected CustomHandler(int size, BiPredicate<Integer, ItemStack> isValidPredicate) {
            super(size);
            this.isValidPredicate = isValidPredicate;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.isValidPredicate.test(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            MachineProcessBlockEntity.this.setChanged();
        }
    }
}

