/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.GristWildcardHolder;
import com.mraof.minestuck.blockentity.machine.IOwnable;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.ProgressTracker;
import com.mraof.minestuck.event.AlchemyEvent;
import com.mraof.minestuck.inventory.MiniAlchemiterMenu;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class MiniAlchemiterBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider,
IOwnable,
GristWildcardHolder {
    public static final String TITLE = "container.minestuck.mini_alchemiter";
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int MAX_PROGRESS = 100;
    private final ProgressTracker progressTracker = new ProgressTracker(ProgressTracker.RunType.ONCE_OR_LOOPING, 100, () -> ((MiniAlchemiterBlockEntity)this).setChanged(), this::contentsValid);
    private final DataSlot wildcardGristHolder = new DataSlot(){

        public int get() {
            return GristTypes.REGISTRY.getId((Object)MiniAlchemiterBlockEntity.this.getWildcardGrist());
        }

        public void set(int id) {
            GristType type = (GristType)GristTypes.REGISTRY.byId(id);
            if (type == null) {
                type = GristTypes.BUILD.get();
            }
            MiniAlchemiterBlockEntity.this.setWildcardGrist(type);
        }
    };
    private int ticks_since_update = 0;
    @Nullable
    private PlayerIdentifier owner;
    private GristType wildcardGrist = GristTypes.BUILD.get();

    public MiniAlchemiterBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.MINI_ALCHEMITER.get(), pos, state);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(2, (slot, stack) -> slot == 0 && stack.getItem() == ((Block)MSBlocks.CRUXITE_DOWEL.get()).asItem());
    }

    private boolean contentsValid() {
        if (!this.level.hasNeighborSignal(this.getBlockPos()) && !this.itemHandler.getStackInSlot(0).isEmpty() && this.owner != null) {
            ItemStack newItem = EncodedItemComponent.getEncodedOrBlank(this.itemHandler.getStackInSlot(0));
            if (newItem.isEmpty()) {
                return false;
            }
            ItemStack existingOutput = this.itemHandler.getStackInSlot(1);
            if (!(existingOutput.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)existingOutput, (ItemStack)newItem) && existingOutput.getMaxStackSize() >= existingOutput.getCount() + newItem.getCount())) {
                return false;
            }
            GristSet cost = GristCostRecipe.findCostForItem(newItem, this.wildcardGrist, false, this.level);
            return GristCache.get(this.level, this.owner).canAfford(cost);
        }
        return false;
    }

    private void processContents() {
        ItemStack card = this.itemHandler.getStackInSlot(0);
        ItemStack newItem = EncodedItemComponent.getEncodedOrBlank(card);
        GristSet cost = GristCostRecipe.findCostForItem(newItem, this.wildcardGrist, false, this.level);
        Objects.requireNonNull(cost);
        if (GristCache.get(this.level, this.owner).tryTake(cost, GristHelper.EnumSource.CLIENT)) {
            AlchemyEvent event = new AlchemyEvent(this.owner, this, this.itemHandler.getStackInSlot(0), newItem, cost);
            NeoForge.EVENT_BUS.post((Event)event);
            newItem = event.getItemResult();
            ItemStack existing = this.itemHandler.getStackInSlot(1);
            if (!existing.isEmpty()) {
                newItem.grow(existing.getCount());
            }
            this.itemHandler.setStackInSlot(1, newItem);
        }
    }

    @Override
    protected void tick() {
        this.progressTracker.tick(this::processContents);
        if (this.ticks_since_update == 20) {
            this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
            this.ticks_since_update = 0;
        } else {
            ++this.ticks_since_update;
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.progressTracker.load(nbt);
        this.wildcardGrist = GristHelper.parseGristType(nbt.get("gristType")).orElseGet(GristTypes.BUILD);
        this.owner = IdentifierHandler.load(nbt, "owner").result().orElse(null);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.progressTracker.save(compound);
        compound.put("gristType", GristHelper.encodeGristType(this.wildcardGrist));
        if (this.owner != null) {
            this.owner.saveToNBT(compound, "owner");
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.DOWN) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2);
        }
        return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1);
    }

    public int comparatorValue() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        if (!input.isEmpty() && this.owner != null) {
            ItemStack newItem = EncodedItemComponent.getEncodedOrBlank(input);
            if (newItem.isEmpty()) {
                return 0;
            }
            ItemStack output = this.itemHandler.getStackInSlot(1);
            if (!(output.isEmpty() || output.getItem() == newItem.getItem() && output.getMaxStackSize() > output.getCount())) {
                return 0;
            }
            GristSet cost = GristCostRecipe.findCostForItem(newItem, this.wildcardGrist, false, this.level);
            if (cost != null && !input.isEmpty()) {
                for (int lvl = 1; lvl <= 17; ++lvl) {
                    if (lvl == 17) {
                        return 15;
                    }
                    MutableGristSet scale_cost = cost.mutableCopy().scale(lvl);
                    if (GristCache.get(this.level, this.owner).canAfford(scale_cost)) continue;
                    return lvl - 1;
                }
            }
        }
        return 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new MiniAlchemiterMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.progressTracker, this.wildcardGristHolder, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.worldPosition);
    }

    public GristType getWildcardGrist() {
        return this.wildcardGrist;
    }

    @Override
    public void setWildcardGrist(GristType wildcardGrist) {
        if (this.wildcardGrist != wildcardGrist) {
            this.wildcardGrist = wildcardGrist;
            this.setChanged();
        }
    }

    @Override
    public void setOwner(PlayerIdentifier identifier) {
        this.owner = identifier;
    }

    @Override
    @Nullable
    public PlayerIdentifier getOwner() {
        return this.owner;
    }
}

