/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.ProgressTracker;
import com.mraof.minestuck.inventory.MiniCruxtruderMenu;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.ColorHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class MiniCruxtruderBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider {
    public static final String TITLE = "container.minestuck.mini_cruxtruder";
    public static final int MAX_PROGRESS = 100;
    private final ProgressTracker progressTracker = new ProgressTracker(ProgressTracker.RunType.AUTOMATIC, 100, () -> ((MiniCruxtruderBlockEntity)this).setChanged(), this::contentsValid);
    public int color = 10542335;

    public MiniCruxtruderBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.MINI_CRUXTRUDER.get(), pos, state);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(2, (index, stack) -> index == 0 && stack.getItem() == MSItems.RAW_CRUXITE.get());
    }

    @Override
    protected void tick() {
        this.progressTracker.tick(this::processContents);
    }

    private boolean contentsValid() {
        ItemStack stack1 = this.itemHandler.getStackInSlot(1);
        return !this.level.hasNeighborSignal(this.getBlockPos()) && !this.itemHandler.getStackInSlot(0).isEmpty() && (stack1.isEmpty() || stack1.getCount() < stack1.getMaxStackSize() && ColorHandler.getColorFromStack(stack1) == this.color);
    }

    private void processContents() {
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            this.itemHandler.setStackInSlot(1, ColorHandler.setColor(new ItemStack((ItemLike)MSBlocks.CRUXITE_DOWEL.get()), this.color));
        } else {
            this.itemHandler.extractItem(1, -1, false);
        }
        this.itemHandler.extractItem(0, 1, false);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.progressTracker.load(nbt);
        this.color = nbt.getInt("color");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.progressTracker.save(compound);
        compound.putInt("color", this.color);
        super.saveAdditional(compound, provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        this.color = (Integer)componentInput.getOrDefault(MSItemComponents.COLOR, (Object)this.color);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(MSItemComponents.COLOR, (Object)this.color);
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.DOWN) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2);
        }
        return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new MiniCruxtruderMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.progressTracker, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.worldPosition);
    }
}

