/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationInput;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipe;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.ProgressTracker;
import com.mraof.minestuck.inventory.MiniPunchDesignixMenu;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.CardStoredItemComponent;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class MiniPunchDesignixBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider {
    public static final String TITLE = "container.minestuck.mini_punch_designix";
    public static final int MAX_PROGRESS = 100;
    private final ProgressTracker progressTracker = new ProgressTracker(ProgressTracker.RunType.ONCE, 100, () -> ((MiniPunchDesignixBlockEntity)this).setChanged(), this::contentsValid);

    public MiniPunchDesignixBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.MINI_PUNCH_DESIGNIX.get(), pos, state);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(3, (index, stack) -> index == 0 || index == 1 && stack.is((Item)MSItems.CAPTCHA_CARD.get())){

            @Override
            protected void onContentsChanged(int slot) {
                MiniPunchDesignixBlockEntity.this.progressTracker.resetProgress();
                super.onContentsChanged(slot);
            }
        };
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.progressTracker.load(nbt);
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.progressTracker.save(compound);
    }

    private boolean contentsValid() {
        boolean bothHaveItems;
        boolean bl = bothHaveItems = !this.itemHandler.getStackInSlot(0).isEmpty() && !this.itemHandler.getStackInSlot(1).isEmpty();
        if (bothHaveItems) {
            ItemStack output = this.createResult();
            if (output.isEmpty()) {
                return false;
            }
            ItemStack currentOutput = this.itemHandler.getStackInSlot(2);
            return currentOutput.isEmpty() || currentOutput.getCount() < 16 && ItemStack.isSameItemSameComponents((ItemStack)currentOutput, (ItemStack)output);
        }
        return false;
    }

    @Override
    protected void tick() {
        this.progressTracker.tick(this::processContents);
    }

    private void processContents() {
        boolean shouldConsumeCaptchaInput;
        ItemStack captchaInput = this.itemHandler.getStackInSlot(0);
        boolean bl = shouldConsumeCaptchaInput = !captchaInput.is(MSItems.CAPTCHA_CARD) || !captchaInput.has(MSItemComponents.ENCODED_ITEM) && !captchaInput.has(MSItemComponents.CARD_STORED_ITEM);
        if (!this.itemHandler.getStackInSlot(2).isEmpty()) {
            this.itemHandler.extractItem(1, 1, false);
            if (shouldConsumeCaptchaInput) {
                this.itemHandler.extractItem(0, 1, false);
            }
            this.itemHandler.extractItem(2, -1, false);
            return;
        }
        ItemStack outputItem = this.createResult();
        this.itemHandler.setStackInSlot(2, outputItem);
        if (shouldConsumeCaptchaInput) {
            this.itemHandler.extractItem(0, 1, false);
        }
        this.itemHandler.extractItem(1, 1, false);
    }

    private ItemStack createResult() {
        ItemStack output;
        ItemStack captchaInput = this.itemHandler.getStackInSlot(0);
        EncodedItemComponent captchaPunchedInput = (EncodedItemComponent)captchaInput.get(MSItemComponents.ENCODED_ITEM);
        CardStoredItemComponent captchaStoredInput = (CardStoredItemComponent)captchaInput.get(MSItemComponents.CARD_STORED_ITEM);
        if (captchaInput.is(MSItems.CAPTCHA_CARD) && captchaPunchedInput != null) {
            output = captchaPunchedInput.asItemStack();
        } else if (captchaInput.is(MSItems.CAPTCHA_CARD) && captchaStoredInput != null) {
            if (!captchaInput.has(MSItemComponents.CAPTCHA_CODE)) {
                return ItemStack.EMPTY;
            }
            output = captchaStoredInput.storedStack().copy();
        } else {
            output = captchaInput.copy();
        }
        EncodedItemComponent punchedInput = (EncodedItemComponent)this.itemHandler.getStackInSlot(1).get(MSItemComponents.ENCODED_ITEM);
        if (punchedInput != null) {
            output = CombinationRecipe.findResult(new CombinationInput(output, punchedInput.asItemStack(), CombinationMode.OR), this.level);
        }
        if (output.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return CaptchaCardItem.createPunchedCard(output.getItem());
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    private IItemHandlerModifiable createInputSlotHandler() {
        return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (MiniPunchDesignixBlockEntity.this.itemHandler.getStackInSlot(2).isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.DOWN) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.createInputSlotHandler(), new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 2, 3)});
        }
        if (side == Direction.UP) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2);
        }
        return this.createInputSlotHandler();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new MiniPunchDesignixMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.progressTracker, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.worldPosition);
    }
}

