/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.UraniumPowered;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PowerHubBlockEntity
extends BlockEntity {
    public static final String POWER_PROMPT = "block.minestuck.power_hub.power_prompt";
    public static final short MAX_POWER = 256;
    private short power = 0;

    public PowerHubBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.POWER_HUB.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.power = compound.getShort("power");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putShort("power", this.power);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PowerHubBlockEntity blockEntity) {
        UraniumPowered poweredBlockEntity;
        BlockEntity blockEntity2;
        if (level.getGameTime() % 400L == 0L) {
            blockEntity.increasePower();
        }
        if (blockEntity.power > 0 && (blockEntity2 = level.getBlockEntity(pos.above())) instanceof UraniumPowered && !(poweredBlockEntity = (UraniumPowered)blockEntity2).atMaxFuel()) {
            poweredBlockEntity.addFuel((short)1);
            blockEntity.changePower(-1);
        }
    }

    public void sendStatusMessage(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)POWER_PROMPT, (Object[])new Object[]{this.getPower()}), true);
    }

    public void increasePower() {
        if (this.power < 256) {
            this.changePower(1);
        }
    }

    public short getPower() {
        return this.power;
    }

    private void changePower(int amount) {
        this.power = (short)(this.power + (short)amount);
        this.setChanged();
    }
}

