/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;

@ParametersAreNonnullByDefault
public final class ProgressTracker
implements ContainerData {
    public static final int PROGRESS_INDEX = 0;
    public static final int RUN_INDEX = 1;
    public static final int LOOPING_INDEX = 2;
    private final RunType type;
    private final int maxProgress;
    private final Runnable onChanged;
    private final BooleanSupplier isValid;
    private int progress = 0;
    private boolean shouldRun = false;
    private boolean isLooping = false;

    public ProgressTracker(RunType type, int maxProgress, Runnable onChanged, BooleanSupplier isValid) {
        this.type = type;
        this.maxProgress = maxProgress;
        this.onChanged = onChanged;
        this.isValid = isValid;
        this.updateRunAndLooping();
    }

    public void resetProgress() {
        if (this.shouldRun) {
            boolean changed = this.progress != 0;
            this.progress = 0;
            this.shouldRun = false;
            this.updateRunAndLooping();
            if (changed) {
                this.onChanged.run();
            }
        }
    }

    public void setShouldRun(boolean shouldRun) {
        if (shouldRun) {
            this.shouldRun |= this.isValid.getAsBoolean();
        } else {
            this.resetProgress();
        }
    }

    public void setIsLooping(boolean isLooping) {
        boolean wasLooping = this.isLooping;
        this.isLooping = isLooping;
        this.updateRunAndLooping();
        if (wasLooping != this.isLooping) {
            this.onChanged.run();
        }
    }

    private void updateRunAndLooping() {
        this.isLooping |= this.type == RunType.AUTOMATIC;
        this.isLooping &= this.type != RunType.ONCE;
        this.shouldRun |= this.isLooping;
    }

    public void tick(Runnable onComplete) {
        if (!this.shouldRun || !this.isValid.getAsBoolean()) {
            this.resetProgress();
            return;
        }
        ++this.progress;
        this.onChanged.run();
        if (this.progress >= this.maxProgress) {
            this.resetProgress();
            onComplete.run();
        }
    }

    public void load(CompoundTag tag) {
        this.progress = tag.getInt("progress");
        if (this.type == RunType.ONCE_OR_LOOPING) {
            this.isLooping = tag.getBoolean("isLooping");
        }
        this.shouldRun = this.progress != 0 || this.isLooping;
    }

    public void save(CompoundTag tag) {
        tag.putInt("progress", this.progress);
        if (this.type == RunType.ONCE_OR_LOOPING) {
            tag.putBoolean("isLooping", this.isLooping);
        }
    }

    public int get(int index) {
        return switch (index) {
            case 0 -> this.progress;
            case 1 -> {
                if (this.shouldRun) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> {
                if (this.isLooping) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new UnsupportedOperationException("Unknown data index was used: " + index);
        };
    }

    public void set(int index, int value) {
        switch (index) {
            case 0: {
                throw new UnsupportedOperationException("Progress shouldn't be changed from outside");
            }
            case 1: {
                this.setShouldRun(value != 0);
                break;
            }
            case 2: {
                this.setIsLooping(value != 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data index was used: " + index);
            }
        }
    }

    public int getCount() {
        return 3;
    }

    public static enum RunType {
        AUTOMATIC,
        ONCE,
        ONCE_OR_LOOPING;

    }
}

