/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.alchemy.CardCaptchas;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationInput;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipe;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.block.machine.PunchDesignixBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.CaptchaCodeComponent;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PunchDesignixBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean broken = false;
    private ItemStack card = ItemStack.EMPTY;
    private String captcha = "";
    public static final String REJECT_CARD = "block.minestuck.punch_designix.code_rejected";

    public PunchDesignixBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.PUNCH_DESIGNIX.get(), pos, state);
    }

    public void setCard(ItemStack card) {
        if (card.getItem() == MSItems.CAPTCHA_CARD.get() || card.isEmpty()) {
            this.card = card;
            this.updateState();
        }
    }

    public void setCaptcha(String captcha) {
        if (this.level == null) {
            return;
        }
        this.captcha = captcha;
        if (!this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void breakMachine() {
        this.broken = true;
        this.setChanged();
    }

    private void updateState() {
        if (this.level != null && !this.level.isClientSide) {
            boolean hasCard;
            BlockState state = this.level.getBlockState(this.worldPosition);
            boolean bl = hasCard = !this.card.isEmpty();
            if (state.hasProperty((Property)PunchDesignixBlock.Slot.HAS_CARD) && hasCard != (Boolean)state.getValue((Property)PunchDesignixBlock.Slot.HAS_CARD)) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)PunchDesignixBlock.Slot.HAS_CARD, (Comparable)Boolean.valueOf(hasCard)), 2);
            }
        }
    }

    @Nonnull
    public ItemStack getCard() {
        return this.card;
    }

    public String getCaptcha() {
        return this.captcha;
    }

    public void onRightClick(Player player, BlockState clickedState) {
        this.validateMachine();
        Block part = clickedState.getBlock();
        if (part instanceof PunchDesignixBlock.Slot && !player.level().isClientSide) {
            this.handleSlotClick(player);
        } else if (this.isUsable(clickedState) && (part == MSBlocks.PUNCH_DESIGNIX.KEYBOARD.get() || part == MSBlocks.PUNCH_DESIGNIX.RIGHT_LEG.get())) {
            this.handleKeyboardClick(player);
        }
    }

    private void handleSlotClick(Player player) {
        ItemStack heldStack;
        if (!this.getCard().isEmpty()) {
            if (player.getMainHandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, this.getCard());
            } else if (!player.getInventory().add(this.getCard())) {
                this.dropItem(false);
            } else {
                player.inventoryMenu.broadcastChanges();
            }
            this.setCard(ItemStack.EMPTY);
        } else if (!this.broken && !(heldStack = player.getMainHandItem()).isEmpty() && heldStack.getItem() == MSItems.CAPTCHA_CARD.get()) {
            this.setCard(heldStack.split(1));
        }
    }

    private void handleKeyboardClick(Player player) {
        ItemStack heldStack = player.getMainHandItem();
        if (player.level().isClientSide) {
            if (!heldStack.is((Item)MSItems.CAPTCHA_CARD.get())) {
                MSScreenFactories.displayPunchDesignixScreen(this);
            }
        } else if (CaptchaCardItem.isUnpunchedCard(heldStack)) {
            CaptchaCodeComponent captchaCode = (CaptchaCodeComponent)heldStack.get(MSItemComponents.CAPTCHA_CODE);
            if (captchaCode != null) {
                this.setCaptcha(captchaCode.code());
                this.effects(false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)REJECT_CARD), true);
            }
        }
    }

    public void punchCard(ServerPlayer player) {
        Item itemFromCaptcha = CardCaptchas.getItemFromCaptcha(this.captcha, player.server);
        if (itemFromCaptcha != null && !this.getCard().isEmpty()) {
            ItemStack captchaItemStack = itemFromCaptcha.getDefaultInstance();
            EncodedItemComponent encodedItemComponent = (EncodedItemComponent)this.getCard().get(MSItemComponents.ENCODED_ITEM);
            ItemStack storedStackInCard = encodedItemComponent != null ? encodedItemComponent.asItemStack() : ItemStack.EMPTY;
            ItemStack output = !storedStackInCard.isEmpty() ? CombinationRecipe.findResult(new CombinationInput(captchaItemStack, storedStackInCard, CombinationMode.OR), player.level()) : captchaItemStack;
            if (!output.isEmpty()) {
                MSCriteriaTriggers.PUNCH_DESIGNIX.get().trigger(player, captchaItemStack, storedStackInCard, output);
                this.setCard(CaptchaCardItem.createPunchedCard(output.getItem()));
                this.effects(true);
            }
        }
    }

    private void effects(boolean success) {
        if (this.level == null) {
            return;
        }
        this.level.levelEvent(success ? 1000 : 1001, this.worldPosition, 0);
        if (success) {
            Direction direction = (Direction)this.getBlockState().getValue((Property)MachineBlock.FACING);
            int i = direction.getStepX() + 1 + (direction.getStepZ() + 1) * 3;
            this.level.levelEvent(2000, this.worldPosition, i);
        }
    }

    private boolean isUsable(BlockState state) {
        return !this.broken && ((Direction)state.getValue((Property)MachineBlock.FACING)).equals((Object)this.getBlockState().getValue((Property)MachineBlock.FACING));
    }

    private void validateMachine() {
        if (this.broken || this.level == null) {
            return;
        }
        if (MSBlocks.PUNCH_DESIGNIX.isInvalidFromSlot((LevelAccessor)this.level, this.getBlockPos())) {
            this.broken = true;
        }
    }

    public void dropItem(boolean inBlock) {
        Direction direction;
        if (this.level == null) {
            LOGGER.warn("Tried to drop punch designix card before the world had been set!");
            return;
        }
        Direction direction2 = direction = inBlock ? null : (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)MachineBlock.FACING);
        BlockPos dropPos = inBlock ? this.worldPosition : (!Block.canSupportCenter((LevelReader)this.level, (BlockPos)this.worldPosition.relative(direction), (Direction)direction.getOpposite()) ? this.worldPosition.relative(direction) : (!Block.canSupportCenter((LevelReader)this.level, (BlockPos)this.worldPosition.above(), (Direction)Direction.DOWN) ? this.worldPosition.above() : this.worldPosition));
        Containers.dropItemStack((Level)this.level, (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), (ItemStack)this.getCard());
        this.setCard(ItemStack.EMPTY);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.broken = nbt.getBoolean("broken");
        this.setCard(ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound("card")));
        if (nbt.contains("captcha")) {
            this.captcha = nbt.getString("captcha");
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putBoolean("broken", this.broken);
        compound.put("card", this.getCard().saveOptional(provider));
        compound.putString("captcha", this.captcha);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

