/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.ProgressTracker;
import com.mraof.minestuck.blockentity.machine.UraniumPowered;
import com.mraof.minestuck.inventory.OptionalPosHolder;
import com.mraof.minestuck.inventory.SendificatorMenu;
import com.mraof.minestuck.util.ExtraModTags;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class SendificatorBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider,
UraniumPowered {
    public static final String TITLE = "container.minestuck.sendificator";
    public static final short MAX_FUEL = 128;
    private final ProgressTracker progressTracker = new ProgressTracker(ProgressTracker.RunType.ONCE_OR_LOOPING, 0, () -> ((SendificatorBlockEntity)this).setChanged(), this::contentsValid);
    private short fuel = 0;
    @Nullable
    private BlockPos destBlockPos;
    private final DataSlot fuelHolder = new DataSlot(){

        public int get() {
            return SendificatorBlockEntity.this.fuel;
        }

        public void set(int value) {
            SendificatorBlockEntity.this.fuel = (short)value;
        }
    };
    private final OptionalPosHolder destinationHolder = OptionalPosHolder.forPos(() -> Optional.ofNullable(this.getDestinationBlockPos()));

    public SendificatorBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.SENDIFICATOR.get(), pos, state);
    }

    @Nullable
    public BlockPos getDestinationBlockPos() {
        return this.destBlockPos;
    }

    public void setDestinationBlockPos(BlockPos destinationPosIn) {
        this.destBlockPos = destinationPosIn;
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.progressTracker.load(compound);
        if (compound.contains("destX") && compound.contains("destY") && compound.contains("destZ")) {
            int destX = compound.getInt("destX");
            int destY = compound.getInt("destY");
            int destZ = compound.getInt("destZ");
            this.destBlockPos = new BlockPos(destX, destY, destZ);
        }
        this.fuel = compound.getShort("fuel");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.progressTracker.save(compound);
        if (this.destBlockPos != null) {
            compound.putInt("destX", this.destBlockPos.getX());
            compound.putInt("destY", this.destBlockPos.getY());
            compound.putInt("destZ", this.destBlockPos.getZ());
        }
        compound.putShort("fuel", this.fuel);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(2, (index, stack) -> index == 0 || stack.is(ExtraModTags.Items.URANIUM_CHUNKS));
    }

    @Override
    protected void tick() {
        this.progressTracker.tick(this::processContents);
    }

    private boolean contentsValid() {
        if (this.level.hasNeighborSignal(this.getBlockPos())) {
            return false;
        }
        ItemStack fuel = this.itemHandler.getStackInSlot(1);
        ItemStack input = this.itemHandler.getStackInSlot(0);
        return this.canBeRefueled() && fuel.is(ExtraModTags.Items.URANIUM_CHUNKS) || !input.isEmpty();
    }

    private void processContents() {
        if (this.canBeRefueled() && this.itemHandler.getStackInSlot(1).is(ExtraModTags.Items.URANIUM_CHUNKS)) {
            this.addFuel((short)32);
            this.itemHandler.extractItem(1, 1, false);
        }
        if (this.canSend()) {
            BlockPos destinationPos;
            if (this.itemHandler.getStackInSlot(0).hasCraftingRemainingItem()) {
                this.itemHandler.setStackInSlot(0, this.itemHandler.getStackInSlot(0).getCraftingRemainingItem());
            } else if (this.level != null && (destinationPos = this.getDestinationBlockPos()) != null) {
                ItemStack sentStack = this.itemHandler.extractItem(0, 64, false);
                ItemEntity itemEntity = new ItemEntity(this.level, (double)destinationPos.getX(), (double)destinationPos.getY(), (double)destinationPos.getZ(), sentStack);
                this.level.addFreshEntity((Entity)itemEntity);
                this.fuel = (short)(this.fuel - 8);
            }
        }
    }

    private boolean canSend() {
        return this.fuel > 0 && !this.itemHandler.getStackInSlot(0).isEmpty();
    }

    public boolean canBeRefueled() {
        return this.fuel <= 96;
    }

    @Override
    public boolean atMaxFuel() {
        return this.fuel >= 128;
    }

    @Override
    public void addFuel(short fuelAmount) {
        this.fuel = (short)(this.fuel + fuelAmount);
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.UP) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1);
        }
        if (side == Direction.DOWN) {
            return null;
        }
        return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2);
    }

    public void openMenu(ServerPlayer player) {
        player.openMenu((MenuProvider)this, SendificatorMenu.makeExtraDataWriter(this.worldPosition, this.destBlockPos));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new SendificatorMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.progressTracker, this.fuelHolder, this.destinationHolder, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.worldPosition);
    }
}

