/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationInput;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipe;
import com.mraof.minestuck.block.EnumDowelType;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.machine.TotemLatheBlock;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.TotemLatheDowelBlockEntity;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class TotemLatheBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean isProcessing;
    private int animationticks;
    private boolean broken = false;
    private ItemStack card1 = ItemStack.EMPTY;
    private ItemStack card2 = ItemStack.EMPTY;

    public TotemLatheBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.TOTEM_LATHE.get(), pos, state);
    }

    private boolean tryAddCard(ItemStack stack) {
        if (!this.isBroken() && stack.is((Item)MSItems.CAPTCHA_CARD.get())) {
            if (this.card1.isEmpty()) {
                this.card1 = stack;
            } else if (this.card2.isEmpty()) {
                this.card2 = stack;
            } else {
                return false;
            }
            this.updateState();
            return true;
        }
        return false;
    }

    private ItemStack tryTakeCard() {
        ItemStack card = ItemStack.EMPTY;
        if (!this.card2.isEmpty()) {
            card = this.card2;
            this.card2 = ItemStack.EMPTY;
        } else if (!this.card1.isEmpty()) {
            card = this.card1;
            this.card1 = ItemStack.EMPTY;
        }
        if (!card.isEmpty()) {
            this.updateState();
        }
        return card;
    }

    private void updateState() {
        int actualCount;
        int worldCount = (Integer)this.getBlockState().getValue((Property)TotemLatheBlock.Slot.COUNT);
        if (worldCount != (actualCount = this.getActualCardCount())) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TotemLatheBlock.Slot.COUNT, (Comparable)Integer.valueOf(actualCount)));
        }
    }

    private int getActualCardCount() {
        if (!this.card2.isEmpty()) {
            return 2;
        }
        if (!this.card1.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @Nonnull
    public ItemStack getCard1() {
        return this.card1;
    }

    public ItemStack getCard2() {
        return this.card2;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken() {
        this.broken = true;
    }

    public void dropItems() {
        Objects.requireNonNull(this.level);
        BlockPos pos = this.getBlockPos();
        if (!this.card1.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.card1);
            this.card1 = ItemStack.EMPTY;
        }
        if (!this.card2.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.card2);
            this.card2 = ItemStack.EMPTY;
        }
    }

    public boolean setDowel(ItemStack dowelStack) {
        Objects.requireNonNull(this.level);
        if (!dowelStack.is((Item)MSItems.CRUXITE_DOWEL.get()) && !dowelStack.isEmpty()) {
            return false;
        }
        Direction facing = this.getFacing();
        BlockPos dowelPos = MSBlocks.TOTEM_LATHE.getDowelPos(this.getBlockPos(), this.getBlockState());
        BlockState oldState = this.level.getBlockState(dowelPos);
        BlockState newState = (BlockState)((BlockState)((Block)MSBlocks.TOTEM_LATHE.DOWEL_ROD.get()).defaultBlockState().setValue((Property)TotemLatheBlock.FACING, (Comparable)facing)).setValue(TotemLatheBlock.DowelRod.DOWEL, (Comparable)((Object)EnumDowelType.getForDowel(dowelStack)));
        if (this.isValidDowelRod(oldState, facing)) {
            BlockEntity be = this.level.getBlockEntity(dowelPos);
            if (!(be instanceof TotemLatheDowelBlockEntity)) {
                be = new TotemLatheDowelBlockEntity(dowelPos, newState);
                this.level.setBlockEntity(be);
            }
            TotemLatheDowelBlockEntity beItem = (TotemLatheDowelBlockEntity)be;
            beItem.setStack(dowelStack);
            if (!oldState.equals(newState)) {
                this.level.setBlockAndUpdate(dowelPos, newState);
            } else {
                this.level.sendBlockUpdated(dowelPos, oldState, oldState, 3);
            }
            this.isProcessing = false;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            return true;
        }
        return false;
    }

    private void setCarvedItem(ItemStack output) {
        Objects.requireNonNull(this.level);
        Direction facing = this.getFacing();
        BlockPos pos = MSBlocks.TOTEM_LATHE.getDowelPos(this.getBlockPos(), this.getBlockState());
        BlockState oldState = this.level.getBlockState(pos);
        if (!this.isValidDowelRod(oldState, facing)) {
            return;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (!(be instanceof ItemStackBlockEntity)) {
            return;
        }
        ItemStackBlockEntity beItem = (ItemStackBlockEntity)be;
        ItemStack oldDowel = beItem.getStack();
        ItemStack newDowel = EncodedItemComponent.setEncodedUnlessBlank(oldDowel.copy().split(1), output.getItem());
        beItem.setStack(newDowel);
        BlockState newState = (BlockState)((BlockState)((Block)MSBlocks.TOTEM_LATHE.DOWEL_ROD.get()).defaultBlockState().setValue((Property)TotemLatheBlock.FACING, (Comparable)facing)).setValue(TotemLatheBlock.DowelRod.DOWEL, (Comparable)((Object)EnumDowelType.getForDowel(newDowel)));
        if (!oldState.equals(newState)) {
            this.level.setBlockAndUpdate(pos, newState);
        } else {
            this.level.sendBlockUpdated(pos, oldState, newState, 2);
        }
    }

    public ItemStack getDowel() {
        BlockEntity blockEntity;
        BlockPos pos = MSBlocks.TOTEM_LATHE.getDowelPos(this.getBlockPos(), this.getBlockState());
        if (this.isValidDowelRod(this.level.getBlockState(pos), this.getFacing()) && (blockEntity = this.level.getBlockEntity(pos)) instanceof TotemLatheDowelBlockEntity) {
            TotemLatheDowelBlockEntity blockEntity2 = (TotemLatheDowelBlockEntity)blockEntity;
            return blockEntity2.getStack();
        }
        return ItemStack.EMPTY;
    }

    private boolean isValidDowelRod(BlockState state, Direction facing) {
        return state.is((Block)MSBlocks.TOTEM_LATHE.DOWEL_ROD.get()) && state.getValue((Property)TotemLatheBlock.FACING) == facing;
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)TotemLatheBlock.FACING);
    }

    public void onRightClick(Player player, BlockState clickedState) {
        boolean working = this.isUseable(clickedState);
        if (clickedState.getBlock() instanceof TotemLatheBlock.Slot) {
            this.handleSlotClick(player, working);
        }
        if (clickedState.is((Block)MSBlocks.TOTEM_LATHE.DOWEL_ROD.get())) {
            this.handleDowelClick(player, working);
        }
        if (clickedState.is((Block)MSBlocks.TOTEM_LATHE.TOP.get()) && this.level != null) {
            boolean startingCarving = false;
            if (!(!working || this.getDowel().isEmpty() || this.getDowel().has(MSItemComponents.ENCODED_ITEM) || this.card1.isEmpty() && this.card2.isEmpty())) {
                this.level.playSound(null, this.getBlockPos(), MSSoundEvents.TOTEM_LATHE_LATHE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                startingCarving = true;
                this.isProcessing = true;
                this.animationticks = 25;
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            this.level.levelEvent(startingCarving ? 1000 : 1001, this.getBlockPos(), 0);
        }
    }

    private void handleSlotClick(Player player, boolean isWorking) {
        ItemStack heldStack = player.getMainHandItem();
        ItemStack card = heldStack.copy().split(1);
        if (this.tryAddCard(card)) {
            heldStack.shrink(1);
        } else {
            card = this.tryTakeCard();
            if (!card.isEmpty()) {
                if (player.getMainHandItem().isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, card);
                } else if (!player.getInventory().add(card)) {
                    this.dropItem(false, this.getBlockPos(), card);
                } else {
                    player.inventoryMenu.broadcastChanges();
                }
            }
        }
    }

    private void handleDowelClick(Player player, boolean isWorking) {
        ItemStack heldStack = player.getMainHandItem();
        ItemStack dowel = this.getDowel();
        if (dowel.isEmpty()) {
            if (isWorking && heldStack.is((Item)MSItems.CRUXITE_DOWEL.get())) {
                ItemStack copy = heldStack.copy();
                copy.setCount(1);
                if (this.setDowel(copy)) {
                    heldStack.shrink(1);
                }
            }
        } else {
            if (player.getMainHandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.MAIN_HAND, dowel);
            } else if (!player.getInventory().add(dowel)) {
                this.dropItem(true, this.getBlockPos().above().relative(this.getFacing().getCounterClockWise(), 2), dowel);
            } else {
                player.inventoryMenu.broadcastChanges();
            }
            this.setDowel(ItemStack.EMPTY);
        }
    }

    private boolean isUseable(BlockState state) {
        BlockState currentState = this.getLevel().getBlockState(this.getBlockPos());
        if (!this.isBroken()) {
            this.checkStates();
            if (this.isBroken()) {
                LOGGER.warn("Failed to notice a block being broken or misplaced at the totem lathe at {}", (Object)this.getBlockPos());
            }
        }
        if (!((Direction)state.getValue((Property)TotemLatheBlock.FACING)).equals((Object)currentState.getValue((Property)TotemLatheBlock.FACING))) {
            return false;
        }
        return !this.isBroken();
    }

    public void checkStates() {
        if (this.isBroken()) {
            return;
        }
        if (MSBlocks.TOTEM_LATHE.isInvalidFromSlot((BlockGetter)this.level, this.getBlockPos())) {
            this.setBroken();
        }
    }

    private void dropItem(boolean inBlock, BlockPos pos, ItemStack stack) {
        Direction direction = this.getFacing();
        BlockPos dropPos = inBlock ? pos : (!Block.canSupportCenter((LevelReader)this.level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite()) ? pos.relative(direction) : pos);
        Containers.dropItemStack((Level)this.level, (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), (ItemStack)stack);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.broken = nbt.getBoolean("broken");
        this.card1 = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound("card1"));
        this.card2 = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound("card2"));
        this.isProcessing = nbt.getBoolean("isProcessing");
        if (this.card1.isEmpty() && !this.card2.isEmpty()) {
            this.card1 = this.card2;
            this.card2 = ItemStack.EMPTY;
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putBoolean("broken", this.broken);
        compound.put("card1", this.card1.saveOptional(provider));
        compound.put("card2", this.card2.saveOptional(provider));
        compound.putBoolean("isProcessing", this.isProcessing);
    }

    private void processContents(Level level) {
        ItemStack dowel = this.getDowel();
        if (!(dowel.isEmpty() || dowel.has(MSItemComponents.ENCODED_ITEM) || this.card1.isEmpty() && this.card2.isEmpty())) {
            ItemStack output;
            if (!this.card1.isEmpty() && !this.card2.isEmpty()) {
                ItemStack input1 = EncodedItemComponent.getEncodedOrBlank(this.card1);
                ItemStack input2 = EncodedItemComponent.getEncodedOrBlank(this.card2);
                output = input1.is((Item)MSItems.GENERIC_OBJECT.get()) || input2.is((Item)MSItems.GENERIC_OBJECT.get()) ? new ItemStack((ItemLike)MSItems.GENERIC_OBJECT.get()) : CombinationRecipe.findResult(new CombinationInput(input1, input2, CombinationMode.AND), level);
            } else {
                ItemStack input = this.card1.isEmpty() ? this.card2 : this.card1;
                output = EncodedItemComponent.getEncodedOrBlank(input);
            }
            if (!output.isEmpty()) {
                this.setCarvedItem(output);
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TotemLatheBlockEntity blockEntity) {
        if (blockEntity.animationticks > 0) {
            --blockEntity.animationticks;
            if (blockEntity.animationticks <= 0) {
                blockEntity.processContents(level);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }
}

