/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.TotemLatheBlockEntity;
import com.mraof.minestuck.util.ColorHandler;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TotemLatheDowelBlockEntity
extends ItemStackBlockEntity
implements GeoBlockEntity {
    private static final RawAnimation CARVE_ANIMATION = RawAnimation.begin().then("carvetotem", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TotemLatheDowelBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.TOTEM_LATHE_DOWEL.get(), pos, state);
    }

    @Nullable
    private TotemLatheBlockEntity getTotemLatheEntity() {
        if (this.level == null) {
            return null;
        }
        BlockPos pos = MSBlocks.TOTEM_LATHE.getSlotPos(this.getBlockPos(), this.getBlockState());
        BlockEntity be = this.level.getBlockEntity(pos);
        if (be instanceof TotemLatheBlockEntity) {
            return (TotemLatheBlockEntity)be;
        }
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "carveAnimation", 0, this::carveAnimation);
        controller.setParticleKeyframeHandler(this::particleEventListener);
        controllers.add(controller);
    }

    private <T extends GeoAnimatable> void particleEventListener(ParticleKeyframeEvent<T> event) {
        if (this.level == null || this.getTotemLatheEntity() == null) {
            return;
        }
        Direction dir = this.getTotemLatheEntity().getFacing();
        BlockPos blockPos = this.getBlockPos();
        Vector3f pos = new Vector3f((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
        pos.add((float)dir.getCounterClockWise().getStepX() * 0.375f, 0.0f, (float)dir.getCounterClockWise().getStepZ() * 0.375f);
        pos.add(0.5f, 0.3f, 0.5f);
        Color stackColor = new Color(ColorHandler.getColorFromStack(this.getStack()));
        this.level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)stackColor.getRed() / 255.0f, (float)stackColor.getGreen() / 255.0f, (float)stackColor.getBlue() / 255.0f), 1.0f), (double)pos.x(), (double)pos.y(), (double)pos.z(), 1.0, 1.0, 1.0);
    }

    private <E extends BlockEntity> PlayState carveAnimation(AnimationState<E> event) {
        TotemLatheBlockEntity totemLathe = this.getTotemLatheEntity();
        if (totemLathe != null && totemLathe.isProcessing()) {
            event.getController().setAnimation(CARVE_ANIMATION);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }
}

