/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.machine;

import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.blockentity.machine.ProgressTracker;
import com.mraof.minestuck.blockentity.machine.UraniumPowered;
import com.mraof.minestuck.inventory.UraniumCookerMenu;
import com.mraof.minestuck.item.crafting.IrradiatingRecipe;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import com.mraof.minestuck.util.ExtraModTags;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class UraniumCookerBlockEntity
extends MachineProcessBlockEntity
implements MenuProvider,
UraniumPowered {
    public static final String TITLE = "container.minestuck.uranium_cooker";
    private final ProgressTracker progressTracker = new ProgressTracker(ProgressTracker.RunType.ONCE_OR_LOOPING, 0, () -> ((UraniumCookerBlockEntity)this).setChanged(), this::contentsValid);
    private final DataSlot fuelHolder = new DataSlot(){

        public int get() {
            return UraniumCookerBlockEntity.this.fuel;
        }

        public void set(int value) {
            UraniumCookerBlockEntity.this.fuel = (short)value;
        }
    };
    private short fuel = 0;
    public static final short MAX_FUEL = 128;

    public UraniumCookerBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.URANIUM_COOKER.get(), pos, state);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new MachineProcessBlockEntity.CustomHandler(3, (index, stack) -> index == 1 ? stack.is(ExtraModTags.Items.URANIUM_CHUNKS) : index != 2);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putShort("fuel", this.fuel);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.fuel = nbt.getShort("fuel");
    }

    @Override
    protected void tick() {
        this.progressTracker.tick(this::processContents);
    }

    private boolean contentsValid() {
        if (this.level.hasNeighborSignal(this.getBlockPos())) {
            return false;
        }
        ItemStack fuel = this.itemHandler.getStackInSlot(1);
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack output = this.irradiate();
        return this.canBeRefueled() && fuel.is(ExtraModTags.Items.URANIUM_CHUNKS) || !input.isEmpty() && !output.isEmpty();
    }

    private ItemStack irradiate() {
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        SingleRecipeInput recipeInventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        Stream<IrradiatingRecipe> stream = this.level.getRecipeManager().getRecipesFor(MSRecipeTypes.IRRADIATING_TYPE.get(), (RecipeInput)recipeInventory, this.level).stream().map(RecipeHolder::value);
        stream = stream.sorted(Comparator.comparingInt(o -> o.isFallback() ? 1 : 0));
        Optional cookingRecipe = stream.flatMap(recipe -> recipe.getCookingRecipe(recipeInventory, this.level).stream()).findFirst();
        return cookingRecipe.map(abstractCookingRecipe -> abstractCookingRecipe.assemble(recipeInventory, (HolderLookup.Provider)this.level.registryAccess())).orElse(ItemStack.EMPTY);
    }

    private void processContents() {
        if (this.canBeRefueled() && this.itemHandler.getStackInSlot(1).is(ExtraModTags.Items.URANIUM_CHUNKS)) {
            this.addFuel((short)32);
            this.itemHandler.extractItem(1, 1, false);
        }
        if (this.canIrradiate()) {
            ItemStack output = this.irradiate();
            if (this.itemHandler.getStackInSlot(2).isEmpty() && this.fuel > 0) {
                this.itemHandler.setStackInSlot(2, output);
            } else {
                this.itemHandler.extractItem(2, -output.getCount(), false);
            }
            if (this.itemHandler.getStackInSlot(0).hasCraftingRemainingItem()) {
                this.itemHandler.setStackInSlot(0, this.itemHandler.getStackInSlot(0).getCraftingRemainingItem());
            } else {
                this.itemHandler.extractItem(0, 1, false);
            }
            this.fuel = (short)(this.fuel - 1);
        }
    }

    private boolean canIrradiate() {
        ItemStack output = this.irradiate();
        if (this.fuel > 0 && !this.itemHandler.getStackInSlot(0).isEmpty() && !output.isEmpty()) {
            ItemStack out = this.itemHandler.getStackInSlot(2);
            return out.isEmpty() || out.getMaxStackSize() >= output.getCount() + out.getCount() && ItemStack.isSameItem((ItemStack)out, (ItemStack)output);
        }
        return false;
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.DOWN) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 2, 3);
        }
        if (side == Direction.UP) {
            return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 1);
        }
        return new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 1, 2);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new UraniumCookerMenu(windowId, playerInventory, (IItemHandler)this.itemHandler, this.progressTracker, this.fuelHolder, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.translatable((String)TITLE);
    }

    public boolean canBeRefueled() {
        return this.fuel <= 96;
    }

    @Override
    public void addFuel(short fuelAmount) {
        this.fuel = (short)(this.fuel + fuelAmount);
    }

    @Override
    public boolean atMaxFuel() {
        return this.fuel >= 128;
    }
}

