/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.redstone.AreaEffectBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.effects.CreativeShockEffect;
import com.mraof.minestuck.effects.MSEffects;
import com.mraof.minestuck.network.block.AreaEffectSettingsPacket;
import com.mraof.minestuck.util.MSRotationUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AreaEffectBlockEntity
extends BlockEntity {
    @Nonnull
    private Holder<MobEffect> effect = MSEffects.CREATIVE_SHOCK;
    private int effectAmplifier;
    @Nonnull
    private BlockPos minAreaOffset = new BlockPos(-16, -16, -16);
    @Nonnull
    private BlockPos maxAreaOffset = new BlockPos(16, 16, 16);

    public AreaEffectBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.AREA_EFFECT.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AreaEffectBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 0)) {
            return;
        }
        if (level.getGameTime() % 80L == 0L && !level.isClientSide && ((Boolean)state.getValue((Property)AreaEffectBlock.POWERED)).booleanValue() && !((Boolean)state.getValue((Property)AreaEffectBlock.SHUT_DOWN)).booleanValue()) {
            blockEntity.giveEntitiesEffect();
        }
    }

    public void giveEntitiesEffect() {
        Objects.requireNonNull(this.level);
        BlockPos bePos = this.getBlockPos();
        Direction beFacing = (Direction)this.getBlockState().getValue((Property)AreaEffectBlock.FACING);
        BlockPos minAreaPos = bePos.offset((Vec3i)this.minAreaOffset.rotate(MSRotationUtil.rotationBetween(Direction.EAST, beFacing)));
        BlockPos maxAreaPos = bePos.offset((Vec3i)this.maxAreaOffset.rotate(MSRotationUtil.rotationBetween(Direction.EAST, beFacing)));
        if (((Boolean)this.getBlockState().getValue((Property)AreaEffectBlock.ALL_MOBS)).booleanValue()) {
            for (LivingEntity livingEntity : this.level.getEntitiesOfClass(LivingEntity.class, AABB.encapsulatingFullBlocks((BlockPos)minAreaPos, (BlockPos)maxAreaPos))) {
                this.iterateThroughEntities(livingEntity);
            }
        } else {
            for (Player playerEntity : this.level.getEntitiesOfClass(Player.class, AABB.encapsulatingFullBlocks((BlockPos)minAreaPos, (BlockPos)maxAreaPos))) {
                this.iterateThroughEntities((LivingEntity)playerEntity);
            }
        }
    }

    private void iterateThroughEntities(LivingEntity entityIterate) {
        if (this.effect instanceof CreativeShockEffect) {
            entityIterate.addEffect(new MobEffectInstance(this.effect, 120, this.effectAmplifier, false, false));
        } else {
            Player player;
            boolean ignoreEntity;
            boolean bl = ignoreEntity = entityIterate instanceof Player && (player = (Player)entityIterate).isCreative() && !((MobEffect)this.effect.value()).isBeneficial();
            if (!ignoreEntity) {
                entityIterate.addEffect(new MobEffectInstance(this.effect, ((MobEffect)this.effect.value()).isInstantenous() ? 1 : 120, this.effectAmplifier, false, false));
            }
        }
    }

    public void setEffect(Holder<MobEffect> effectIn, int effectAmplifierIn) {
        this.effect = Objects.requireNonNull(effectIn);
        this.effectAmplifier = effectAmplifierIn;
        this.setChanged();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public MobEffect getEffect() {
        return (MobEffect)this.effect.value();
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public BlockPos getMinAreaOffset() {
        return this.minAreaOffset;
    }

    public BlockPos getMaxAreaOffset() {
        return this.maxAreaOffset;
    }

    public void handleSettingsPacket(AreaEffectSettingsPacket packet) {
        Objects.requireNonNull(this.level);
        this.minAreaOffset = AreaEffectBlockEntity.clampMinPos(packet.minEffectPos().getX(), packet.minEffectPos().getY(), packet.minEffectPos().getZ());
        this.maxAreaOffset = AreaEffectBlockEntity.clampMaxPos(packet.maxEffectPos().getX(), packet.maxEffectPos().getY(), packet.maxEffectPos().getZ());
        this.setChanged();
        this.setEffect(packet.effect(), packet.effectAmp());
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)AreaEffectBlock.ALL_MOBS, (Comparable)Boolean.valueOf(packet.isAllMobs())), 3);
    }

    public static BlockPos clampMinPos(int x, int y, int z) {
        return new BlockPos(Math.max(x, -64), Math.max(y, -64), Math.max(z, -64));
    }

    public static BlockPos clampMaxPos(int x, int y, int z) {
        return new BlockPos(Math.min(x, 64), Math.min(y, 64), Math.min(z, 64));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        Optional effectRead = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)compound.getString("effect")));
        effectRead.ifPresent(mobEffectReference -> {
            this.effect = mobEffectReference;
        });
        this.effectAmplifier = compound.getInt("effectAmplifier");
        int minAreaOffsetX = compound.getInt("minAreaOffsetX");
        int minAreaOffsetY = compound.getInt("minAreaOffsetY");
        int minAreaOffsetZ = compound.getInt("minAreaOffsetZ");
        this.minAreaOffset = AreaEffectBlockEntity.clampMinPos(minAreaOffsetX, minAreaOffsetY, minAreaOffsetZ);
        int maxAreaOffsetX = compound.getInt("maxAreaOffsetX");
        int maxAreaOffsetY = compound.getInt("maxAreaOffsetY");
        int maxAreaOffsetZ = compound.getInt("maxAreaOffsetZ");
        this.maxAreaOffset = AreaEffectBlockEntity.clampMaxPos(maxAreaOffsetX, maxAreaOffsetY, maxAreaOffsetZ);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putString("effect", String.valueOf(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)this.effect.value()))));
        compound.putInt("effectAmplifier", this.effectAmplifier);
        compound.putInt("minAreaOffsetX", this.minAreaOffset.getX());
        compound.putInt("minAreaOffsetY", this.minAreaOffset.getY());
        compound.putInt("minAreaOffsetZ", this.minAreaOffset.getZ());
        compound.putInt("maxAreaOffsetX", this.maxAreaOffset.getX());
        compound.putInt("maxAreaOffsetY", this.maxAreaOffset.getY());
        compound.putInt("maxAreaOffsetZ", this.maxAreaOffset.getZ());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

