/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.network.block.BlockTeleporterSettingsPacket;
import com.mraof.minestuck.util.MSRotationUtil;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockTeleporterBlockEntity
extends BlockEntity {
    @Nonnull
    private BlockPos teleportOffset = new BlockPos(0, 0, 0);

    public BlockTeleporterBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.BLOCK_TELEPORTER.get(), pos, state);
    }

    public void handleTeleports() {
        boolean hardToDestroy;
        if (this.level == null) {
            return;
        }
        Direction facingDirection = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        BlockPos abovePos = this.getBlockPos().above();
        BlockState aboveState = this.level.getBlockState(abovePos);
        if (aboveState.isAir()) {
            return;
        }
        PushReaction pushReaction = aboveState.getPistonPushReaction();
        boolean badPushReaction = pushReaction == PushReaction.BLOCK || pushReaction == PushReaction.IGNORE;
        float defaultDestroyTime = aboveState.getBlock().defaultDestroyTime();
        boolean bl = hardToDestroy = defaultDestroyTime < 0.0f || defaultDestroyTime > 30.0f;
        if (badPushReaction || hardToDestroy || aboveState.hasBlockEntity()) {
            return;
        }
        BlockPos offsetMod = this.teleportOffset.rotate(MSRotationUtil.rotationBetween(Direction.EAST, facingDirection));
        BlockPos destinationPos = new BlockPos((Vec3i)this.getBlockPos().offset((Vec3i)offsetMod));
        BlockState destinationState = this.level.getBlockState(destinationPos);
        if (!BlockUtil.isReplaceable(destinationState)) {
            return;
        }
        this.level.playSound(null, destinationPos, MSSoundEvents.TRANSPORTALIZER_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.setBlock(destinationPos, aboveState, 3);
        this.level.playSound(null, abovePos, MSSoundEvents.TRANSPORTALIZER_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.removeBlock(abovePos, true);
    }

    @Nonnull
    public BlockPos getTeleportOffset() {
        return this.teleportOffset;
    }

    public void handleSettingsPacket(BlockTeleporterSettingsPacket packet) {
        this.teleportOffset = packet.offsetPos();
        this.setChanged();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        int offsetX = compound.getInt("offsetX");
        int offsetY = compound.getInt("offsetY");
        int offsetZ = compound.getInt("offsetZ");
        this.teleportOffset = BlockTeleporterBlockEntity.clampPos(offsetX, offsetY, offsetZ);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("offsetX", this.teleportOffset.getX());
        compound.putInt("offsetY", this.teleportOffset.getY());
        compound.putInt("offsetZ", this.teleportOffset.getZ());
    }

    public static BlockPos clampPos(int x, int y, int z) {
        return new BlockPos(Mth.clamp((int)x, (int)-32, (int)32), Mth.clamp((int)y, (int)-32, (int)32), Mth.clamp((int)z, (int)-32, (int)32));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

