/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.PushableBlock;
import com.mraof.minestuck.block.redstone.ItemMagnetBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemMagnetBlockEntity
extends BlockEntity {
    private int gatherLength;

    public ItemMagnetBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.ITEM_MAGNET.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ItemMagnetBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        blockEntity.sendUpdate();
    }

    private void sendUpdate() {
        if (this.level != null) {
            int powerIn;
            this.gatherLength = powerIn = ((Integer)this.getBlockState().getValue((Property)ItemMagnetBlock.POWER)).intValue();
            if (powerIn > 0) {
                BlockPos randomPosInAABB;
                Direction magnetFacing = (Direction)this.getBlockState().getValue((Property)ItemMagnetBlock.FACING);
                boolean reversePolarity = (Boolean)this.getBlockState().getValue((Property)ItemMagnetBlock.REVERSE_POLARITY);
                if (!this.level.isClientSide && this.level.getGameTime() % 5L == 0L && (magnetFacing == Direction.DOWN && !reversePolarity || magnetFacing == Direction.UP && reversePolarity)) {
                    for (int blockIterate = 1; blockIterate < powerIn + 1; ++blockIterate) {
                        BlockPos iteratePos = new BlockPos((Vec3i)this.getBlockPos().relative(magnetFacing, blockIterate));
                        if (!this.level.isAreaLoaded(this.getBlockPos(), blockIterate) || this.level.isOutsideBuildHeight(iteratePos.getY())) break;
                        BlockState iterateBlockState = this.level.getBlockState(iteratePos);
                        if (!(iterateBlockState.getBlock() instanceof PushableBlock)) continue;
                        FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)this.level, (BlockPos)iteratePos, (BlockState)iterateBlockState);
                        fallingblockentity.time = Integer.MIN_VALUE;
                    }
                }
                BlockPos offsetPosClose = this.getBlockPos().relative(magnetFacing);
                BlockPos offsetPosFar = offsetPosClose.relative(magnetFacing, this.gatherLength);
                AABB axisalignedbb = new AABB((double)offsetPosClose.getX() + 0.5, (double)offsetPosClose.getY() + 0.5, (double)offsetPosClose.getZ() + 0.5, (double)offsetPosFar.getX() + 0.5, (double)offsetPosFar.getY() + 0.5, (double)offsetPosFar.getZ() + 0.5).inflate(0.5);
                List list = this.level.getEntitiesOfClass(Entity.class, axisalignedbb);
                if (!list.isEmpty()) {
                    for (Entity itemEntity : list) {
                        if (!itemEntity.getType().is(MSTags.EntityTypes.MAGNET_RECEPTIVE) && (!(itemEntity instanceof FallingBlockEntity) || !(((FallingBlockEntity)itemEntity).getBlockState().getBlock() instanceof PushableBlock))) continue;
                        Direction momentumFromFacing = magnetFacing.getOpposite();
                        Vec3 facingVec = new Vec3((double)momentumFromFacing.getStepX(), (double)momentumFromFacing.getStepY(), (double)momentumFromFacing.getStepZ());
                        if (reversePolarity) {
                            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add(facingVec).scale(0.2).reverse());
                            continue;
                        }
                        itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add(facingVec).scale(0.2));
                    }
                }
                if (this.level.random.nextInt(6) == 0) {
                    randomPosInAABB = offsetPosFar.relative(magnetFacing.getOpposite(), this.level.random.nextInt(Math.abs(offsetPosFar.compareTo((Vec3i)offsetPosClose))));
                    if (reversePolarity) {
                        this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level.getBlockState(randomPosInAABB.relative(Direction.getRandom((RandomSource)this.level.random)))), (double)randomPosInAABB.getX() + 0.5, (double)randomPosInAABB.getY() + 0.9, (double)randomPosInAABB.getZ() + 0.5, (double)magnetFacing.getStepX(), (double)magnetFacing.getStepY(), (double)magnetFacing.getStepZ());
                    } else {
                        this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level.getBlockState(randomPosInAABB.relative(Direction.getRandom((RandomSource)this.level.random)))), (double)randomPosInAABB.getX() + 0.5, (double)randomPosInAABB.getY() + 0.9, (double)randomPosInAABB.getZ() + 0.5, (double)magnetFacing.getOpposite().getStepX(), (double)magnetFacing.getOpposite().getStepY(), (double)magnetFacing.getOpposite().getStepZ());
                    }
                }
                if (this.level.random.nextInt(3) == 0) {
                    randomPosInAABB = offsetPosFar.relative(magnetFacing.getOpposite(), this.level.random.nextInt(Math.abs(offsetPosFar.compareTo((Vec3i)offsetPosClose))));
                    if (reversePolarity) {
                        this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level.getBlockState(randomPosInAABB.relative(Direction.getRandom((RandomSource)this.level.random)))), (double)randomPosInAABB.getX() + 0.5, (double)randomPosInAABB.getY() + 0.9, (double)randomPosInAABB.getZ() + 0.5, (double)magnetFacing.getStepX(), (double)magnetFacing.getStepY(), (double)magnetFacing.getStepZ());
                    } else {
                        this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.level.getBlockState(randomPosInAABB.relative(Direction.getRandom((RandomSource)this.level.random)))), (double)randomPosInAABB.getX() + 0.5, (double)randomPosInAABB.getY() + 0.9, (double)randomPosInAABB.getZ() + 0.5, (double)magnetFacing.getOpposite().getStepX(), (double)magnetFacing.getOpposite().getStepY(), (double)magnetFacing.getOpposite().getStepZ());
                    }
                }
            }
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.gatherLength = nbt.getInt("gatherLength");
    }

    public void saveAdditional(CompoundTag compoundNBT, HolderLookup.Provider provider) {
        super.saveAdditional(compoundNBT, provider);
        compoundNBT.putInt("gatherLength", this.gatherLength);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

