/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.redstone.PlatformBlock;
import com.mraof.minestuck.block.redstone.PlatformGeneratorBlock;
import com.mraof.minestuck.block.redstone.PlatformReceptacleBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.util.MSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlatformGeneratorBlockEntity
extends BlockEntity {
    private int tickCycle;
    private int platformLength;

    public PlatformGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.PLATFORM_GENERATOR.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PlatformGeneratorBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (blockEntity.tickCycle >= 10) {
            blockEntity.sendUpdate();
            blockEntity.tickCycle = 0;
        }
        ++blockEntity.tickCycle;
    }

    private void sendUpdate() {
        block10: {
            int powerIn;
            if (this.level == null) break block10;
            this.platformLength = powerIn = ((Integer)this.getBlockState().getValue((Property)PlatformGeneratorBlock.POWER)).intValue();
            if (powerIn > 0) {
                for (int blockIterate = 1; blockIterate < this.platformLength + 1; ++blockIterate) {
                    BlockPos iteratePos = new BlockPos((Vec3i)this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)PlatformGeneratorBlock.FACING), blockIterate));
                    if (!this.level.isAreaLoaded(this.getBlockPos(), blockIterate) || this.level.isOutsideBuildHeight(iteratePos)) break;
                    BlockState iterateBlockState = this.level.getBlockState(iteratePos);
                    if (iterateBlockState.getBlock() instanceof PlatformReceptacleBlock) {
                        if (!((Boolean)iterateBlockState.getValue((Property)PlatformReceptacleBlock.ABSORBING)).booleanValue()) continue;
                    } else if (!iterateBlockState.is(MSTags.Blocks.PLATFORM_ABSORBING)) {
                        if (BlockUtil.isReplaceable(iterateBlockState)) {
                            if (!iterateBlockState.isAir()) {
                                this.level.destroyBlock(iteratePos, true);
                            }
                            this.generatePlatform(this.level, iteratePos, blockIterate);
                            continue;
                        }
                        if (!this.shouldReplaceExistingPlatformBlock(iteratePos, blockIterate)) continue;
                        this.generatePlatform(this.level, iteratePos, blockIterate);
                        continue;
                    }
                    break;
                }
            } else {
                for (int blockIterate = 1; blockIterate < 16; ++blockIterate) {
                    BlockPos iteratePos = new BlockPos((Vec3i)this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)PlatformGeneratorBlock.FACING), blockIterate));
                    if (this.level.isAreaLoaded(this.getBlockPos(), blockIterate) && !this.level.isOutsideBuildHeight(iteratePos.getY())) {
                        BlockState iterateBlockState = this.level.getBlockState(iteratePos);
                        if (!(iterateBlockState.getBlock() instanceof PlatformBlock)) continue;
                        PlatformBlock.updateSurvival(iterateBlockState, this.level, iteratePos);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private boolean shouldReplaceExistingPlatformBlock(BlockPos pos, int loopIteration) {
        BlockState state;
        if (this.level != null && (state = this.level.getBlockState(pos)).getBlock() instanceof PlatformBlock) {
            PlatformBlock.updateSurvival(state, this.level, pos);
            state = this.level.getBlockState(pos);
            return !(state.getBlock() instanceof PlatformBlock);
        }
        return false;
    }

    private void generatePlatform(Level level, BlockPos pos, int loopIteration) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((Block)MSBlocks.PLATFORM_BLOCK.get()).defaultBlockState().setValue((Property)PlatformBlock.INVISIBLE, (Comparable)((Boolean)this.getBlockState().getValue((Property)PlatformGeneratorBlock.INVISIBLE_MODE)))).setValue((Property)PlatformBlock.FACING, (Comparable)((Direction)this.getBlockState().getValue((Property)PlatformGeneratorBlock.FACING)))).setValue((Property)PlatformBlock.GENERATOR_DISTANCE, (Comparable)Integer.valueOf(loopIteration)));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tickCycle = compound.getInt("tickCycle");
        this.platformLength = compound.getInt("platformLength");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tickCycle", this.tickCycle);
        compound.putInt("platformLength", this.platformLength);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

