/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.redstone.RedstoneClockBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneClockBlockEntity
extends BlockEntity {
    private int tickCycle;
    private int clockSpeed;
    public static final String TIME_CHANGE = "block.minestuck.redstone_clock.time_change";

    public RedstoneClockBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.REDSTONE_CLOCK.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RedstoneClockBlockEntity blockEntity) {
        if (blockEntity.clockSpeed < 20) {
            blockEntity.setClockSpeed(20);
        }
        if (blockEntity.tickCycle >= blockEntity.clockSpeed) {
            blockEntity.sendUpdate();
            blockEntity.tickCycle = 0;
        }
        ++blockEntity.tickCycle;
    }

    private void sendUpdate() {
        if (this.level != null && this.level.isAreaLoaded(this.getBlockPos(), 1)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)RedstoneClockBlock.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            this.level.scheduleTick(new BlockPos((Vec3i)this.getBlockPos()), this.level.getBlockState(this.getBlockPos()).getBlock(), 10);
            if (!this.level.getBlockState(this.getBlockPos().above()).is(BlockTags.OCCLUDES_VIBRATION_SIGNALS) && !this.level.getBlockState(this.getBlockPos().below()).is(BlockTags.OCCLUDES_VIBRATION_SIGNALS)) {
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.05f, 1.2f);
            }
        }
    }

    public void incrementClockSpeed(Player playerEntity) {
        if (this.clockSpeed <= 1190) {
            this.clockSpeed += 10;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.6f);
        } else {
            this.clockSpeed = 20;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.6f);
        }
        playerEntity.displayClientMessage((Component)Component.translatable((String)TIME_CHANGE, (Object[])new Object[]{(double)this.clockSpeed / 20.0}), true);
    }

    public void decrementClockSpeed(Player playerEntity) {
        if (this.clockSpeed >= 30) {
            this.clockSpeed -= 10;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, 1.6f);
        } else {
            this.clockSpeed = 1200;
            this.level.playSound(null, this.getBlockPos(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, 1.6f);
        }
        playerEntity.displayClientMessage((Component)Component.translatable((String)TIME_CHANGE, (Object[])new Object[]{(double)this.clockSpeed / 20.0}), true);
    }

    public void setClockSpeed(int clockSpeed) {
        this.clockSpeed = clockSpeed;
    }

    public int getClockSpeed() {
        return this.clockSpeed;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tickCycle = compound.getInt("tickCycle");
        this.clockSpeed = compound.getInt("clockSpeed");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tickCycle", this.tickCycle);
        compound.putInt("clockSpeed", this.clockSpeed);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

